/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema;

import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.alibaba.graphscope.sdkcommon.schema.PropertyDef;
import com.alibaba.graphscope.sdkcommon.schema.TypeDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GraphVertexImpl
implements GraphVertex {
    private TypeDef typeDef;
    private PrimaryKeyConstraint primaryKeyConstraint;
    private long tableId;

    public GraphVertexImpl(TypeDef typeDef, long tableId) {
        this.typeDef = typeDef;
        List<PropertyDef> properties = typeDef.getProperties();
        List<Integer> pkIdxs = typeDef.getPkIdxs();
        ArrayList<String> pkNameList = new ArrayList<String>(pkIdxs.size());
        for (Integer pkIdx : pkIdxs) {
            PropertyDef propertyDef = properties.get(pkIdx);
            pkNameList.add(propertyDef.getName());
        }
        this.primaryKeyConstraint = new PrimaryKeyConstraint(pkNameList);
        this.tableId = tableId;
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        return this.typeDef.getPkPropertyIndices();
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        List<GraphProperty> propertyList = this.getPropertyList();
        return this.getPkPropertyIndices().stream().map(i -> (GraphProperty)propertyList.get((int)i)).collect(Collectors.toList());
    }

    @Override
    public String getLabel() {
        return this.typeDef.getLabel();
    }

    @Override
    public int getLabelId() {
        return this.typeDef.getLabelId();
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.typeDef.getPropertyList();
    }

    @Override
    public GraphProperty getProperty(int propId) {
        return this.typeDef.getProperty(propId);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        return this.typeDef.getProperty(propName);
    }

    @Override
    public int getVersionId() {
        return this.typeDef.getVersionId();
    }

    @Override
    public long getTableId() {
        return this.tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphVertexImpl that = (GraphVertexImpl)o;
        return this.tableId == that.tableId && Objects.equals(this.typeDef, that.typeDef) && Objects.equals(this.primaryKeyConstraint, that.primaryKeyConstraint);
    }

    public int hashCode() {
        return Objects.hash(this.typeDef, this.primaryKeyConstraint, this.tableId);
    }
}

