/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema;

import com.alibaba.graphscope.compiler.api.schema.DataType;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.proto.groot.PropertyDefPb;
import com.alibaba.graphscope.sdkcommon.schema.PropertyValue;
import java.util.Objects;

public class PropertyDef
implements GraphProperty {
    private int id;
    private int innerId;
    private String name;
    private DataType dataType;
    private PropertyValue defaultValue;
    private boolean pk;
    private String comment;

    public PropertyDef(int id, int innerId, String name, DataType dataType, PropertyValue defaultValue, boolean pk, String comment) {
        this.id = id;
        this.innerId = innerId;
        this.name = name;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.pk = pk;
        this.comment = comment;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.getValue();
    }

    public PropertyValue getDefaultPropertyValue() {
        return this.defaultValue;
    }

    public boolean isPartOfPrimaryKey() {
        return this.pk;
    }

    public static PropertyDef parseProto(PropertyDefPb proto) {
        int id = proto.getId();
        int innerId = proto.getInnerId();
        String name = proto.getName();
        DataType dataType = DataType.parseProto(proto.getDataType());
        PropertyValue defaultValue = PropertyValue.parseProto(proto.getDefaultValue());
        boolean pk = proto.getPk();
        String comment = proto.getComment();
        return new PropertyDef(id, innerId, name, dataType, defaultValue, pk, comment);
    }

    public PropertyDefPb toProto() {
        PropertyDefPb.Builder builder = PropertyDefPb.newBuilder();
        if (this.defaultValue != null) {
            builder.setDefaultValue(this.defaultValue.toProto());
        }
        builder.setId(this.id).setInnerId(this.innerId).setName(this.name).setDataType(this.dataType.toProto()).setPk(this.pk);
        if (this.comment != null) {
            builder.setComment(this.comment);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDef that = (PropertyDef)o;
        return this.id == that.id && this.innerId == that.innerId && this.pk == that.pk && Objects.equals(this.name, that.name) && this.dataType == that.dataType && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.comment, that.comment);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PropertyDef propertyDef) {
        return new Builder(propertyDef);
    }

    public static class Builder {
        private int id;
        private int innerId;
        private String name;
        private DataType dataType;
        private PropertyValue defaultValue;
        private boolean pk;
        private String comment;

        private Builder(PropertyDef propertyDef) {
            this.id = propertyDef.id;
            this.innerId = propertyDef.innerId;
            this.name = propertyDef.name;
            this.dataType = propertyDef.dataType;
            this.defaultValue = propertyDef.defaultValue;
            this.pk = propertyDef.pk;
            this.comment = propertyDef.comment;
        }

        public Builder() {
            this.id = 0;
            this.innerId = 0;
            this.name = "";
            this.dataType = DataType.UNKNOWN;
            this.defaultValue = null;
            this.pk = false;
            this.comment = "";
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setInnerId(int innerId) {
            this.innerId = innerId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setDefaultValue(PropertyValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setPk(boolean pk) {
            this.pk = pk;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public PropertyDef build() {
            return new PropertyDef(this.id, this.innerId, this.name, this.dataType, this.defaultValue, this.pk, this.comment);
        }
    }
}

