/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema;

import com.alibaba.graphscope.compiler.api.schema.DataType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SerdeUtils {
    public static byte[] objectToBytes(DataType dataType, Object valObject) {
        try {
            switch (dataType) {
                case BOOL: {
                    return new byte[]{(byte)((Boolean)valObject != false ? 1 : 0)};
                }
                case CHAR: {
                    return ByteBuffer.allocate(2).putChar(((Character)valObject).charValue()).array();
                }
                case SHORT: {
                    return ByteBuffer.allocate(2).putShort(Short.valueOf(valObject.toString())).array();
                }
                case INT: {
                    return ByteBuffer.allocate(4).putInt(Integer.valueOf(valObject.toString())).array();
                }
                case LONG: {
                    return ByteBuffer.allocate(8).putLong(Long.valueOf(valObject.toString())).array();
                }
                case FLOAT: {
                    return ByteBuffer.allocate(4).putFloat(Float.valueOf(valObject.toString()).floatValue()).array();
                }
                case DOUBLE: {
                    return ByteBuffer.allocate(8).putDouble(Double.valueOf(valObject.toString())).array();
                }
                case STRING: {
                    return ((String)valObject).getBytes(StandardCharsets.UTF_8);
                }
                case BYTES: {
                    return (byte[])valObject;
                }
                case INT_LIST: {
                    List intList = ((List)valObject).stream().map(o -> Integer.valueOf(o.toString())).collect(Collectors.toList());
                    return SerdeUtils.listToBytes(intList, (dos, e) -> {
                        try {
                            dos.writeInt((int)e);
                        }
                        catch (IOException ex) {
                            throw new IllegalArgumentException("write to bytes failed", ex);
                        }
                        return null;
                    });
                }
                case LONG_LIST: {
                    List longList = ((List)valObject).stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
                    return SerdeUtils.listToBytes(longList, (dos, e) -> {
                        try {
                            dos.writeLong((long)e);
                        }
                        catch (IOException ex) {
                            throw new IllegalArgumentException("write to bytes failed", ex);
                        }
                        return null;
                    });
                }
                case FLOAT_LIST: {
                    List floatList = ((List)valObject).stream().map(o -> Float.valueOf(o.toString())).collect(Collectors.toList());
                    return SerdeUtils.listToBytes(floatList, (dos, e) -> {
                        try {
                            dos.writeFloat(e.floatValue());
                        }
                        catch (IOException ex) {
                            throw new IllegalArgumentException("write to bytes failed", ex);
                        }
                        return null;
                    });
                }
                case DOUBLE_LIST: {
                    List doubleList = ((List)valObject).stream().map(o -> Double.valueOf(o.toString())).collect(Collectors.toList());
                    return SerdeUtils.listToBytes(doubleList, (dos, e) -> {
                        try {
                            dos.writeDouble((double)e);
                        }
                        catch (IOException ex) {
                            throw new IllegalArgumentException("write to bytes failed", ex);
                        }
                        return null;
                    });
                }
                case STRING_LIST: {
                    List stringList = ((List)valObject).stream().map(o -> o.toString()).collect(Collectors.toList());
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos2 = new DataOutputStream(bos);
                    dos2.writeInt(stringList.size());
                    int off = 0;
                    ArrayList<byte[]> bytesList = new ArrayList<byte[]>(stringList.size());
                    for (String str : stringList) {
                        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                        bytesList.add(bytes);
                        dos2.writeInt(off += bytes.length);
                    }
                    for (byte[] bytes : bytesList) {
                        dos2.write(bytes);
                    }
                    return bos.toByteArray();
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)dataType));
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("unable to parse object to bytes. DataType [" + (Object)((Object)dataType) + "], Object [" + valObject + "], class [" + valObject.getClass() + "]", e2);
        }
    }

    public static Object bytesToObject(DataType dataType, byte[] valBytes) {
        try {
            Object valObject;
            switch (dataType) {
                case BOOL: {
                    valObject = valBytes[0] != 0;
                    break;
                }
                case CHAR: {
                    valObject = Character.valueOf(ByteBuffer.wrap(valBytes).getChar());
                    break;
                }
                case SHORT: {
                    valObject = ByteBuffer.wrap(valBytes).getShort();
                    break;
                }
                case INT: {
                    valObject = ByteBuffer.wrap(valBytes).getInt();
                    break;
                }
                case LONG: {
                    valObject = ByteBuffer.wrap(valBytes).getLong();
                    break;
                }
                case FLOAT: {
                    valObject = Float.valueOf(ByteBuffer.wrap(valBytes).getFloat());
                    break;
                }
                case DOUBLE: {
                    valObject = ByteBuffer.wrap(valBytes).getDouble();
                    break;
                }
                case STRING: {
                    valObject = new String(valBytes, StandardCharsets.UTF_8);
                    break;
                }
                case BYTES: {
                    valObject = valBytes;
                    break;
                }
                case INT_LIST: {
                    valObject = SerdeUtils.parseListVal(valBytes, dis -> {
                        try {
                            return dis.readInt();
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("parse val failed", e);
                        }
                    });
                    break;
                }
                case LONG_LIST: {
                    valObject = SerdeUtils.parseListVal(valBytes, dis -> {
                        try {
                            return dis.readLong();
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("parse val failed", e);
                        }
                    });
                    break;
                }
                case FLOAT_LIST: {
                    valObject = SerdeUtils.parseListVal(valBytes, dis -> {
                        try {
                            return Float.valueOf(dis.readFloat());
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("parse val failed", e);
                        }
                    });
                    break;
                }
                case DOUBLE_LIST: {
                    valObject = SerdeUtils.parseListVal(valBytes, dis -> {
                        try {
                            return dis.readDouble();
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("parse val failed", e);
                        }
                    });
                    break;
                }
                case STRING_LIST: {
                    DataInputStream dis2 = new DataInputStream(new ByteArrayInputStream(valBytes));
                    int size = dis2.readInt();
                    ArrayList<Integer> strAccumulatedLength = new ArrayList<Integer>(size);
                    for (int i = 0; i < size; ++i) {
                        strAccumulatedLength.add(dis2.readInt());
                    }
                    ArrayList<String> list = new ArrayList<String>(size);
                    if (size != 0) {
                        int len = (Integer)strAccumulatedLength.get(0);
                        list.add(new String(SerdeUtils.readBytes(dis2, len)));
                        for (int i = 1; i < size; ++i) {
                            len = (Integer)strAccumulatedLength.get(i) - (Integer)strAccumulatedLength.get(i - 1);
                            list.add(new String(SerdeUtils.readBytes(dis2, len)));
                        }
                    }
                    valObject = list;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)dataType));
                }
            }
            return valObject;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("parse val failed", e);
        }
    }

    private static byte[] readBytes(DataInputStream dis, int len) throws IOException {
        byte[] bytes = new byte[len];
        dis.read(bytes);
        return bytes;
    }

    private static <T> List<T> parseListVal(byte[] val, Function<DataInputStream, T> func) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(val));
        int size = dis.readInt();
        ArrayList<T> l = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            l.add(func.apply(dis));
        }
        return l;
    }

    private static <T> byte[] listToBytes(List<T> list, BiFunction<DataOutputStream, T, Void> f) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(list.size());
        for (T element : list) {
            f.apply(dos, (DataOutputStream)element);
        }
        return bos.toByteArray();
    }
}

