/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema;

import com.alibaba.graphscope.compiler.api.schema.GraphElement;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.alibaba.graphscope.proto.groot.PropertyDefPb;
import com.alibaba.graphscope.proto.groot.TypeDefPb;
import com.alibaba.graphscope.sdkcommon.schema.LabelId;
import com.alibaba.graphscope.sdkcommon.schema.PropertyDef;
import com.alibaba.graphscope.sdkcommon.schema.TypeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeDef
implements GraphElement {
    private int versionId;
    private String label;
    private LabelId labelId;
    private List<PropertyDef> properties;
    private List<Integer> pkIdxs;
    private Map<String, Integer> nameToIdx;
    private Map<Integer, Integer> idToIdx;
    private TypeEnum typeEnum;

    private TypeDef(TypeEnum typeEnum, int versionId, String label, LabelId labelId, List<PropertyDef> properties) {
        this.typeEnum = typeEnum;
        this.versionId = versionId;
        this.label = label;
        this.labelId = labelId;
        this.properties = new ArrayList<PropertyDef>(properties);
        this.pkIdxs = new ArrayList<Integer>();
        this.nameToIdx = new HashMap<String, Integer>();
        this.idToIdx = new HashMap<Integer, Integer>();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyDef propertyDef = this.properties.get(i);
            if (propertyDef.isPartOfPrimaryKey()) {
                this.pkIdxs.add(i);
            }
            this.nameToIdx.put(propertyDef.getName(), i);
            this.idToIdx.put(propertyDef.getId(), i);
        }
    }

    public List<Integer> getPkIdxs() {
        return Collections.unmodifiableList(this.pkIdxs);
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        return this.getPkIdxs();
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.labelId.getId();
    }

    public LabelId getTypeLabelId() {
        return this.labelId;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return new ArrayList<GraphProperty>(this.getProperties());
    }

    @Override
    public GraphProperty getProperty(int propId) {
        Integer idx = this.idToIdx.get(propId);
        if (idx == null) {
            return null;
        }
        return this.properties.get(idx);
    }

    @Override
    public GraphProperty getProperty(String propName) {
        Integer idx = this.nameToIdx.get(propName);
        if (idx == null) {
            return null;
        }
        return this.properties.get(idx);
    }

    public List<PropertyDef> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public static TypeDef parseProto(TypeDefPb proto) {
        int versionId = proto.getVersionId();
        String label = proto.getLabel();
        LabelId labelId = LabelId.parseProto(proto.getLabelId());
        ArrayList<PropertyDef> propertyDefs = new ArrayList<PropertyDef>();
        List<PropertyDefPb> propsList = proto.getPropsList();
        for (PropertyDefPb propertyDefPb : propsList) {
            propertyDefs.add(PropertyDef.parseProto(propertyDefPb));
        }
        TypeEnum typeEnum = TypeEnum.parseProto(proto.getTypeEnum());
        return new TypeDef(typeEnum, versionId, label, labelId, propertyDefs);
    }

    public TypeDefPb toProto() {
        TypeDefPb.Builder builder = TypeDefPb.newBuilder();
        builder.setVersionId(this.versionId);
        builder.setLabel(this.label);
        builder.setLabelId(this.labelId.toProto());
        for (PropertyDef property : this.properties) {
            builder.addProps(property.toProto());
        }
        builder.setTypeEnum(this.typeEnum.toProto());
        return builder.build();
    }

    public TypeDefPb toDdlProto() {
        TypeDefPb.Builder builder = TypeDefPb.newBuilder();
        builder.setLabel(this.label);
        for (PropertyDef property : this.properties) {
            builder.addProps(property.toProto());
        }
        if (this.typeEnum != null) {
            builder.setTypeEnum(this.typeEnum.toProto());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDef typeDef = (TypeDef)o;
        return this.versionId == typeDef.versionId && Objects.equals(this.label, typeDef.label) && Objects.equals(this.labelId, typeDef.labelId) && Objects.equals(this.properties, typeDef.properties);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TypeDef typeDef) {
        return new Builder(typeDef);
    }

    public static class Builder {
        private int versionId;
        private String label;
        private LabelId labelId;
        private List<PropertyDef> properties = new ArrayList<PropertyDef>();
        private TypeEnum typeEnum;

        private Builder() {
        }

        private Builder(TypeDef typeDef) {
            this.versionId = typeDef.getVersionId();
            this.label = typeDef.getLabel();
            this.labelId = typeDef.getTypeLabelId();
            this.properties = typeDef.getProperties();
            this.typeEnum = typeDef.typeEnum;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setLabelId(LabelId labelId) {
            this.labelId = labelId;
            return this;
        }

        public Builder addPropertyDef(PropertyDef propertyDef) {
            this.properties.add(propertyDef);
            return this;
        }

        public Builder setPropertyDefs(List<PropertyDef> propertyDefs) {
            this.properties = propertyDefs;
            return this;
        }

        public Builder setTypeEnum(TypeEnum typeEnum) {
            this.typeEnum = typeEnum;
            return this;
        }

        public TypeDef build() {
            return new TypeDef(this.typeEnum, this.versionId, this.label, this.labelId, this.properties);
        }
    }
}

