/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema.mapper;

import com.alibaba.graphscope.compiler.api.exception.GraphPropertyNotFoundException;
import com.alibaba.graphscope.compiler.api.schema.EdgeRelation;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGraphEdge
implements GraphEdge {
    private String label;
    private int id;
    private List<GraphProperty> propertyList;
    private List<EdgeRelation> relationList;
    private int versionId;

    public DefaultGraphEdge(String label, int id, List<GraphProperty> propertyList, List<EdgeRelation> relationList, int versionId) {
        this.label = label;
        this.id = id;
        this.propertyList = propertyList;
        this.relationList = relationList;
        this.versionId = versionId;
    }

    @Override
    public List<EdgeRelation> getRelationList() {
        return this.relationList;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.id;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public GraphProperty getProperty(int propertyId) throws GraphPropertyNotFoundException {
        for (GraphProperty property : this.propertyList) {
            if (property.getId() != propertyId) continue;
            return property;
        }
        throw new GraphPropertyNotFoundException("property with id " + propertyId + " not found in vertex " + this.label);
    }

    @Override
    public GraphProperty getProperty(String propertyName) throws GraphPropertyNotFoundException {
        for (GraphProperty property : this.propertyList) {
            if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propertyName)) continue;
            return property;
        }
        throw new GraphPropertyNotFoundException("property with name " + propertyName + " not found in vertex " + this.label);
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return null;
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        return null;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("label", (Object)this.getLabel()).add("id", this.getLabelId()).add("propertyList", this.getPropertyList()).add("relationList", this.getRelationList()).toString();
    }
}

