/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema.mapper;

import com.alibaba.graphscope.compiler.api.exception.GraphElementNotFoundException;
import com.alibaba.graphscope.compiler.api.exception.GraphPropertyNotFoundException;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphElement;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphSchema;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultGraphSchema
implements GraphSchema {
    private static final DefaultGraphSchema SCHEMA = new DefaultGraphSchema();
    private Map<String, GraphVertex> vertexList = Maps.newHashMap();
    private Map<String, GraphEdge> edgeList = Maps.newHashMap();

    public static DefaultGraphSchema getSchema() {
        return SCHEMA;
    }

    public void createVertexType(GraphVertex graphVertex) {
        this.vertexList.put(graphVertex.getLabel(), graphVertex);
    }

    public void createEdgeType(GraphEdge graphEdge) {
        this.edgeList.put(graphEdge.getLabel(), graphEdge);
    }

    public void dropVertexType(String label) {
        this.vertexList.remove(label);
    }

    public void dropEdgeType(String label) {
        this.edgeList.remove(label);
    }

    public void addProperty(String label, GraphProperty property) {
        List<GraphProperty> propertyList = this.getElement(label).getPropertyList();
        propertyList.add(property);
    }

    public void dropProperty(String label, String property) {
        this.getElement(label).getPropertyList().removeIf(v -> StringUtils.equals((CharSequence)v.getName(), (CharSequence)property));
    }

    @Override
    public GraphElement getElement(String label) throws GraphElementNotFoundException {
        HashMap elementList = Maps.newHashMap(this.vertexList);
        elementList.putAll(this.edgeList);
        if (elementList.containsKey(label)) {
            return (GraphElement)elementList.get(label);
        }
        throw new GraphElementNotFoundException("cant found element for label " + label);
    }

    @Override
    public GraphElement getElement(int labelId) throws GraphElementNotFoundException {
        for (GraphVertex graphVertex : this.vertexList.values()) {
            if (graphVertex.getLabelId() != labelId) continue;
            return graphVertex;
        }
        for (GraphEdge graphEdge : this.edgeList.values()) {
            if (graphEdge.getLabelId() != labelId) continue;
            return graphEdge;
        }
        throw new GraphElementNotFoundException("Not found schema element for label id " + labelId);
    }

    @Override
    public List<GraphVertex> getVertexList() {
        return Lists.newArrayList(this.vertexList.values());
    }

    @Override
    public List<GraphEdge> getEdgeList() {
        return Lists.newArrayList(this.edgeList.values());
    }

    @Override
    public Integer getPropertyId(String propertyName) throws GraphPropertyNotFoundException {
        GraphProperty property2;
        HashMap typePropertyIds = Maps.newHashMap();
        for (GraphVertex graphVertex : this.vertexList.values()) {
            try {
                property2 = graphVertex.getProperty(propertyName);
                typePropertyIds.put(graphVertex.getLabelId(), property2.getId());
            }
            catch (Exception property2) {}
        }
        for (GraphEdge graphEdge : this.edgeList.values()) {
            try {
                property2 = graphEdge.getProperty(propertyName);
                typePropertyIds.put(graphEdge.getLabelId(), property2.getId());
            }
            catch (Exception exception) {}
        }
        return (Integer)typePropertyIds.values().iterator().next();
    }

    @Override
    public String getPropertyName(int propertyId) throws GraphPropertyNotFoundException {
        HashMap labelPropertyNameList = Maps.newHashMap();
        for (GraphElement graphElement : this.vertexList.values()) {
            try {
                labelPropertyNameList.put(graphElement.getLabel(), graphElement.getProperty(propertyId).getName());
            }
            catch (Exception exception) {}
        }
        for (GraphElement graphElement : this.edgeList.values()) {
            try {
                labelPropertyNameList.put(graphElement.getLabel(), graphElement.getProperty(propertyId).getName());
            }
            catch (Exception exception) {}
        }
        return (String)labelPropertyNameList.values().iterator().next();
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(String propName) {
        HashMap elementPropertyList = Maps.newHashMap();
        this.vertexList.forEach((key, value) -> {
            for (GraphProperty property : value.getPropertyList()) {
                if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propName)) continue;
                elementPropertyList.put(value, property);
            }
        });
        this.edgeList.forEach((key, value) -> {
            for (GraphProperty property : value.getPropertyList()) {
                if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propName)) continue;
                elementPropertyList.put(value, property);
            }
        });
        return elementPropertyList;
    }

    @Override
    public Map<GraphElement, GraphProperty> getPropertyList(int propId) {
        try {
            String propName = this.getPropertyName(propId);
            return this.getPropertyList(propName);
        }
        catch (Exception ignored) {
            return Maps.newHashMap();
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("vertexTypes", this.vertexList).add("edgeTypes", this.edgeList).toString();
    }
}

