/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema.mapper;

import com.alibaba.graphscope.compiler.api.exception.GraphPropertyNotFoundException;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultGraphVertex
implements GraphVertex {
    private String label;
    private int labelId;
    private List<GraphProperty> propertyList;
    private PrimaryKeyConstraint primaryKeyConstraint;
    private int versionId;
    private long tableId;

    public DefaultGraphVertex(String label, int labelId, List<GraphProperty> propertyList, List<String> primaryKeyList, int versionId, long tableId) {
        this.label = label;
        this.labelId = labelId;
        this.propertyList = propertyList;
        this.primaryKeyConstraint = new PrimaryKeyConstraint(primaryKeyList);
        this.versionId = versionId;
        this.tableId = tableId;
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    @Override
    public List<Integer> getPkPropertyIndices() {
        return null;
    }

    @Override
    public List<GraphProperty> getPrimaryKeyList() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getLabelId() {
        return this.labelId;
    }

    @Override
    public List<GraphProperty> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public GraphProperty getProperty(int propertyId) throws GraphPropertyNotFoundException {
        for (GraphProperty property : this.propertyList) {
            if (property.getId() != propertyId) continue;
            return property;
        }
        throw new GraphPropertyNotFoundException("property with id " + propertyId + " not found in vertex " + this.label);
    }

    @Override
    public GraphProperty getProperty(String propertyName) throws GraphPropertyNotFoundException {
        for (GraphProperty property : this.propertyList) {
            if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)propertyName)) continue;
            return property;
        }
        throw new GraphPropertyNotFoundException("property with name " + propertyName + " not found in vertex " + this.label);
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("label", (Object)this.getLabel()).add("labelId", this.getLabelId()).add("propertyList", this.getPropertyList()).add("primaryKeyConstraint", (Object)this.getPrimaryKeyConstraint()).add("versionId", this.getVersionId()).add("tableId", this.getTableId()).toString();
    }

    @Override
    public long getTableId() {
        return this.tableId;
    }
}

