/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema.mapper;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.graphscope.compiler.api.schema.EdgeRelation;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.sdkcommon.schema.TypeEnum;
import com.alibaba.graphscope.sdkcommon.schema.mapper.DefaultGraphEdge;
import com.alibaba.graphscope.sdkcommon.schema.mapper.EdgeRelationMapper;
import com.alibaba.graphscope.sdkcommon.schema.mapper.GraphPropertyMapper;
import com.alibaba.graphscope.sdkcommon.schema.mapper.SchemaElementMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EdgeTypeMapper
extends SchemaElementMapper {
    @JSONField
    private List<EdgeRelationMapper> relationShips;

    public static SchemaElementMapper parseFromEdgeType(GraphEdge graphEdge) {
        EdgeTypeMapper edgeTypeMapper = new EdgeTypeMapper();
        edgeTypeMapper.setId(graphEdge.getLabelId());
        edgeTypeMapper.setLabel(graphEdge.getLabel());
        edgeTypeMapper.setType(TypeEnum.EDGE.toString());
        ArrayList relationMapperList = Lists.newArrayList();
        for (EdgeRelation edgeRelation : graphEdge.getRelationList()) {
            relationMapperList.add(EdgeRelationMapper.parseFromEdgeRelation(graphEdge.getLabel(), edgeRelation));
        }
        edgeTypeMapper.setRelationShips(relationMapperList);
        ArrayList propertyMapperList = Lists.newArrayList();
        for (GraphProperty graphProperty : graphEdge.getPropertyList()) {
            propertyMapperList.add(GraphPropertyMapper.parseFromGrapyProperty(graphProperty));
        }
        edgeTypeMapper.setPropertyDefList(propertyMapperList);
        return edgeTypeMapper;
    }

    public List<EdgeRelationMapper> getRelationShips() {
        return this.relationShips;
    }

    public void setRelationShips(List<EdgeRelationMapper> relationShips) {
        this.relationShips = relationShips;
    }

    public GraphEdge toEdgeType(Map<String, GraphVertex> vertexTypeMap) {
        ArrayList graphPropertyList = null == this.getPropertyDefList() ? Lists.newArrayList() : this.getPropertyDefList().stream().map(GraphPropertyMapper::toGraphProperty).collect(Collectors.toList());
        ArrayList relationList = Lists.newArrayList();
        if (null != this.relationShips) {
            for (EdgeRelationMapper relationMapper : this.relationShips) {
                relationList.add(relationMapper.toEdgeRelation(vertexTypeMap));
            }
        }
        return new DefaultGraphEdge(this.getLabel(), this.getId(), graphPropertyList, relationList, this.getVersionId());
    }
}

