/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.schema.mapper;

import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.alibaba.graphscope.sdkcommon.schema.TypeEnum;
import com.alibaba.graphscope.sdkcommon.schema.mapper.DefaultGraphVertex;
import com.alibaba.graphscope.sdkcommon.schema.mapper.GraphPropertyMapper;
import com.alibaba.graphscope.sdkcommon.schema.mapper.SchemaElementMapper;
import com.alibaba.graphscope.sdkcommon.schema.mapper.VertexIndexMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class VertexTypeMapper
extends SchemaElementMapper {
    private List<VertexIndexMapper> indexes;
    private long tableId;

    public static VertexTypeMapper parseFromVertexType(GraphVertex graphVertex) {
        VertexTypeMapper vertexTypeMapper = new VertexTypeMapper();
        vertexTypeMapper.setId(graphVertex.getLabelId());
        vertexTypeMapper.setLabel(graphVertex.getLabel());
        vertexTypeMapper.setType(TypeEnum.VERTEX.toString());
        PrimaryKeyConstraint primaryKeyConstraint = graphVertex.getPrimaryKeyConstraint();
        VertexIndexMapper vertexIndexMapper = new VertexIndexMapper();
        vertexIndexMapper.setName("primary_key");
        vertexIndexMapper.setIndexType("PRIMARY_KEY");
        vertexIndexMapper.setPropertyNames(primaryKeyConstraint.getPrimaryKeyList());
        vertexTypeMapper.setIndexes(Lists.newArrayList((Object[])new VertexIndexMapper[]{vertexIndexMapper}));
        ArrayList propertyMapperList = Lists.newArrayList();
        for (GraphProperty graphProperty : graphVertex.getPropertyList()) {
            propertyMapperList.add(GraphPropertyMapper.parseFromGrapyProperty(graphProperty));
        }
        vertexTypeMapper.setPropertyDefList(propertyMapperList);
        vertexTypeMapper.setVersionId(graphVertex.getVersionId());
        vertexTypeMapper.setTableId(graphVertex.getTableId());
        return vertexTypeMapper;
    }

    public List<VertexIndexMapper> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<VertexIndexMapper> indexes) {
        this.indexes = indexes;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public GraphVertex toVertexType() {
        List<GraphProperty> graphPropertyList = this.getPropertyDefList().stream().map(GraphPropertyMapper::toGraphProperty).collect(Collectors.toList());
        ArrayList primaryKeyList = Lists.newArrayList();
        if (this.indexes.size() == 1) {
            primaryKeyList.addAll(this.indexes.get(0).getPropertyNames());
        } else if (this.indexes.size() > 1) {
            throw new IllegalArgumentException("Only support primary key now for " + this.indexes);
        }
        return new DefaultGraphVertex(this.getLabel(), this.getId(), graphPropertyList, primaryKeyList, this.getVersionId(), this.getTableId());
    }
}

