/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.util;

import com.alibaba.graphscope.sdkcommon.exception.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.paranamer.ParanamerModule;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JSON {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJson(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JSONException("JsonProcessingException : ", e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeRef) throws RuntimeException {
        try {
            return (T)(StringUtils.isEmpty((CharSequence)json) ? null : OBJECT_MAPPER.readValue(json, typeRef));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new JSONException("IOException : ", e);
        }
    }

    public static JsonNode fromJson(String json) {
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new JSONException("IOException : ", e);
        }
    }

    public static JsonNode parseJsonTree(String json) throws Exception {
        return StringUtils.isEmpty((CharSequence)json) ? null : OBJECT_MAPPER.readTree(json);
    }

    public static <T> List<T> parseAsList(String json, Class<T> valueType) throws IOException {
        JavaType t = OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{valueType});
        return (List)OBJECT_MAPPER.readValue(json, t);
    }

    static {
        SimpleModule m = new SimpleModule();
        OBJECT_MAPPER.registerModule((Module)m);
        OBJECT_MAPPER.registerModule((Module)new ParanamerModule());
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

