/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.sdkcommon.util;

import com.alibaba.graphscope.compiler.api.schema.DataType;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphSchema;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.compiler.api.schema.PrimaryKeyConstraint;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);
    private static final Set<String> tokenNameList = Sets.newHashSet((Object[])new String[]{T.label.getAccessor(), T.id.getAccessor(), T.key.getAccessor(), T.value.getAccessor()});

    public static List<Integer> getVertexPrimaryKeyList(GraphVertex vertexType) {
        return vertexType.getPrimaryKeyConstraint().getPrimaryKeyList().stream().map(v -> vertexType.getProperty((String)v).getId()).collect(Collectors.toList());
    }

    public static List<Integer> getEdgePrimaryKeyList(GraphEdge edgeType) {
        PrimaryKeyConstraint primaryKeyConstraint = edgeType.getPrimaryKeyConstraint();
        if (primaryKeyConstraint == null) {
            return null;
        }
        return primaryKeyConstraint.getPrimaryKeyList().stream().map(v -> edgeType.getProperty((String)v).getId()).collect(Collectors.toList());
    }

    public static Set<DataType> getDataTypeList(String propName, GraphSchema schema) {
        HashSet dataTypeList = Sets.newHashSet();
        if (tokenNameList.contains(propName)) {
            return dataTypeList;
        }
        for (GraphProperty propertyDef : schema.getPropertyList(propName).values()) {
            dataTypeList.add(propertyDef.getDataType());
        }
        return dataTypeList;
    }

    public static boolean checkPropExist(String propName, GraphSchema schema) {
        try {
            schema.getPropertyId(propName);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static String getPropertyName(int propId, GraphSchema schema) {
        return schema.getPropertyName(propId);
    }

    public static int getPropId(String name, GraphSchema schema) {
        return schema.getPropertyId(name);
    }

    public static Set<DataType> getPropDataTypeList(String propName, GraphSchema schema) {
        HashSet dataTypeList = Sets.newHashSet();
        if (tokenNameList.contains(propName)) {
            return dataTypeList;
        }
        try {
            for (GraphProperty propertyDef : schema.getPropertyList(propName).values()) {
                dataTypeList.add(propertyDef.getDataType());
            }
        }
        catch (Exception e) {
            logger.warn("parse data type for prop " + propName + " fail in schema " + schema, (Throwable)e);
        }
        return dataTypeList;
    }
}

