/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common;

import java.util.HashMap;
import java.util.Map;

public enum RoleType {
    UNKNOWN("unknown"),
    FRONTEND("frontend"),
    FRONTEND_SERVICE("frontend_service"),
    INGESTOR("ingestor"),
    STORE("store"),
    COORDINATOR("coordinator"),
    EXECUTOR_GRAPH("executor_graph"),
    EXECUTOR_QUERY("executor_query"),
    EXECUTOR_MANAGE("executor_manage"),
    EXECUTOR_ENGINE("executor_engine"),
    GAIA_ENGINE("gaia_engine"),
    GAIA_RPC("gaia_rpc");

    private final String name;
    private static final Map<String, RoleType> lookup;

    private RoleType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static RoleType fromName(String roleName) {
        RoleType roleType = lookup.get(roleName);
        if (roleType == null || roleType == UNKNOWN) {
            throw new IllegalArgumentException("Unknown RoleType: [" + roleName + "]");
        }
        return roleType;
    }

    static {
        lookup = new HashMap<String, RoleType>();
        for (RoleType role : RoleType.values()) {
            lookup.put(role.getName(), role);
        }
        lookup.put("store-gaia", STORE);
        lookup.put("frontend-gaia", FRONTEND);
    }
}

