/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import com.alibaba.graphscope.groot.common.config.Configs;
import com.alibaba.graphscope.groot.common.config.ZkConfig;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorUtils {
    public static CuratorFramework makeCurator(Configs configs) {
        String connectionString = ZkConfig.ZK_CONNECT_STRING.get(configs);
        int sessionTimeoutMs = ZkConfig.ZK_SESSION_TIMEOUT_MS.get(configs);
        int connectionTimeoutMs = ZkConfig.ZK_CONNECTION_TIMEOUT_MS.get(configs);
        int baseSleepMs = ZkConfig.ZK_BASE_SLEEP_MS.get(configs);
        int maxSleepMs = ZkConfig.ZK_MAX_SLEEP_MS.get(configs);
        int maxRetry = ZkConfig.ZK_MAX_RETRY.get(configs);
        boolean authEnable = ZkConfig.ZK_AUTH_ENABLE.get(configs);
        String authUser = ZkConfig.ZK_AUTH_USER.get(configs);
        String authPassword = ZkConfig.ZK_AUTH_PASSWORD.get(configs);
        BoundedExponentialBackoffRetry policy = new BoundedExponentialBackoffRetry(baseSleepMs, maxSleepMs, maxRetry);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        builder.connectString(connectionString).retryPolicy((RetryPolicy)policy).sessionTimeoutMs(sessionTimeoutMs).connectionTimeoutMs(connectionTimeoutMs);
        if (authEnable) {
            builder.authorization("digest", (authUser + ":" + authPassword).getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String s) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return builder.build();
    }
}

