/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.groot.common.util;

import com.alibaba.graphscope.compiler.api.schema.DataType;
import com.alibaba.graphscope.compiler.api.schema.GraphEdge;
import com.alibaba.graphscope.compiler.api.schema.GraphElement;
import com.alibaba.graphscope.compiler.api.schema.GraphProperty;
import com.alibaba.graphscope.compiler.api.schema.GraphSchema;
import com.alibaba.graphscope.compiler.api.schema.GraphVertex;
import com.alibaba.graphscope.sdkcommon.util.JSON;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrSchemaParser {
    private static final Logger logger = LoggerFactory.getLogger(IrSchemaParser.class);
    private static IrSchemaParser instance = new IrSchemaParser();

    public static IrSchemaParser getInstance() {
        return instance;
    }

    private IrSchemaParser() {
    }

    public String parse(GraphSchema graphSchema) {
        List vertices = graphSchema.getVertexList();
        List edges = graphSchema.getEdgeList();
        ArrayList entities = new ArrayList();
        ArrayList relations = new ArrayList();
        vertices.forEach(v -> entities.add(this.getVertex(graphSchema, (GraphVertex)v)));
        edges.forEach(e -> relations.add(this.getEdge(graphSchema, (GraphEdge)e)));
        ImmutableMap schemaMap = ImmutableMap.of((Object)"entities", entities, (Object)"relations", relations, (Object)"is_table_id", (Object)true, (Object)"is_column_id", (Object)true);
        return JSON.toJson((Object)schemaMap);
    }

    private Map<String, Object> getVertex(GraphSchema graphSchema, GraphVertex vertex) {
        return this.getElement(graphSchema, (GraphElement)vertex);
    }

    private Map<String, Object> getEdge(GraphSchema graphSchema, GraphEdge edge) {
        LinkedHashMap<String, Object> entity = new LinkedHashMap<String, Object>(this.getElement(graphSchema, (GraphElement)edge));
        List relations = edge.getRelationList();
        List entityPairs = relations.stream().map(k -> {
            GraphVertex src = k.getSource();
            GraphVertex dst = k.getTarget();
            return ImmutableMap.of((Object)"src", (Object)ImmutableMap.of((Object)"id", (Object)src.getLabelId(), (Object)"name", (Object)src.getLabel()), (Object)"dst", (Object)ImmutableMap.of((Object)"id", (Object)dst.getLabelId(), (Object)"name", (Object)dst.getLabel()));
        }).collect(Collectors.toList());
        entity.put("entity_pairs", entityPairs);
        return entity;
    }

    private Map<String, Object> getElement(GraphSchema graphSchema, GraphElement entity) {
        String label = entity.getLabel();
        int labelId = entity.getLabelId();
        List properties = entity.getPropertyList();
        List primaryKeys = entity.getPrimaryKeyList();
        List columns = properties.stream().map(k -> {
            int typeId = this.getDataTypeId(k.getDataType());
            String name = k.getName();
            int nameId = graphSchema.getPropertyId(name);
            return ImmutableMap.of((Object)"key", (Object)ImmutableMap.of((Object)"id", (Object)nameId, (Object)"name", (Object)name), (Object)"data_type", (Object)typeId, (Object)"is_primary_key", (Object)this.isPrimaryKey(label, name, primaryKeys));
        }).collect(Collectors.toList());
        return ImmutableMap.of((Object)"label", (Object)ImmutableMap.of((Object)"id", (Object)labelId, (Object)"name", (Object)label), (Object)"columns", columns);
    }

    private boolean isPrimaryKey(String label, String propertyName, List<GraphProperty> primaryKeys) {
        boolean isPrimaryKey = false;
        if (primaryKeys != null && !primaryKeys.isEmpty()) {
            for (GraphProperty key : primaryKeys) {
                if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)key.getName())) continue;
                isPrimaryKey = true;
                break;
            }
        }
        logger.debug("label {}, property {}, primary key is {}", new Object[]{label, propertyName, isPrimaryKey});
        return isPrimaryKey;
    }

    private int getDataTypeId(DataType dataType) {
        switch (dataType) {
            case BOOL: {
                return 0;
            }
            case INT: {
                return 1;
            }
            case LONG: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
            case STRING: {
                return 4;
            }
            case BYTES: {
                return 5;
            }
            case INT_LIST: {
                return 6;
            }
            case LONG_LIST: {
                return 7;
            }
            case DOUBLE_LIST: {
                return 8;
            }
            case STRING_LIST: {
                return 9;
            }
        }
        return 11;
    }
}

