/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.PegasusConfig;
import com.alibaba.graphscope.common.exception.AppendInterOpException;
import com.alibaba.graphscope.common.exception.BuildPhysicalException;
import com.alibaba.graphscope.common.exception.InterOpIllegalArgException;
import com.alibaba.graphscope.common.exception.InterOpUnsupportedException;
import com.alibaba.graphscope.common.exception.OpArgIllegalException;
import com.alibaba.graphscope.common.intermediate.ArgUtils;
import com.alibaba.graphscope.common.intermediate.InterOpCollection;
import com.alibaba.graphscope.common.intermediate.operator.ApplyOp;
import com.alibaba.graphscope.common.intermediate.operator.AsNoneOp;
import com.alibaba.graphscope.common.intermediate.operator.DedupOp;
import com.alibaba.graphscope.common.intermediate.operator.ExpandOp;
import com.alibaba.graphscope.common.intermediate.operator.GetVOp;
import com.alibaba.graphscope.common.intermediate.operator.GroupOp;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.LimitOp;
import com.alibaba.graphscope.common.intermediate.operator.MatchOp;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.operator.OrderOp;
import com.alibaba.graphscope.common.intermediate.operator.PathExpandOp;
import com.alibaba.graphscope.common.intermediate.operator.ProjectOp;
import com.alibaba.graphscope.common.intermediate.operator.QueryParams;
import com.alibaba.graphscope.common.intermediate.operator.ScanFusionOp;
import com.alibaba.graphscope.common.intermediate.operator.SelectOp;
import com.alibaba.graphscope.common.intermediate.operator.SinkOp;
import com.alibaba.graphscope.common.intermediate.operator.SubGraphAsUnionOp;
import com.alibaba.graphscope.common.intermediate.operator.UnionOp;
import com.alibaba.graphscope.common.intermediate.process.SinkArg;
import com.alibaba.graphscope.common.intermediate.process.SinkByColumns;
import com.alibaba.graphscope.common.intermediate.process.SinkGraph;
import com.alibaba.graphscope.common.jna.IrCoreLibrary;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiBinderOpt;
import com.alibaba.graphscope.common.jna.type.FfiConst;
import com.alibaba.graphscope.common.jna.type.FfiData;
import com.alibaba.graphscope.common.jna.type.FfiDirection;
import com.alibaba.graphscope.common.jna.type.FfiExpandOpt;
import com.alibaba.graphscope.common.jna.type.FfiJoinKind;
import com.alibaba.graphscope.common.jna.type.FfiNameOrId;
import com.alibaba.graphscope.common.jna.type.FfiOrderOpt;
import com.alibaba.graphscope.common.jna.type.FfiResult;
import com.alibaba.graphscope.common.jna.type.FfiScanOpt;
import com.alibaba.graphscope.common.jna.type.FfiVOpt;
import com.alibaba.graphscope.common.jna.type.FfiVariable;
import com.alibaba.graphscope.common.jna.type.ResultCode;
import com.alibaba.graphscope.common.store.IrMeta;
import com.alibaba.graphscope.common.utils.ClassUtils;
import com.alibaba.graphscope.gremlin.Utils;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.javatuples.Pair;

public class IrPlan
implements Closeable {
    private static IrCoreLibrary irCoreLib = IrCoreLibrary.INSTANCE;
    private Pointer ptrPlan;

    public IrPlan(IrMeta meta, InterOpCollection opCollection) {
        irCoreLib.setSchema(meta.getSchema());
        this.ptrPlan = irCoreLib.initLogicalPlan();
        for (InterOpBase op : opCollection.unmodifiableCollection()) {
            QueryParams params = null;
            if (op instanceof ScanFusionOp && ((ScanFusionOp)op).getParams().isPresent()) {
                params = ((ScanFusionOp)op).getParams().get();
            } else if (op instanceof ExpandOp && ((ExpandOp)op).getParams().isPresent()) {
                params = ((ExpandOp)op).getParams().get();
            } else if (op instanceof GetVOp && ((GetVOp)op).getParams().isPresent()) {
                params = ((GetVOp)op).getParams().get();
            }
            if (params == null || !meta.isAcquireSnapshot()) continue;
            params.addExtraParams(QueryParams.SNAPSHOT_CONFIG_NAME, String.valueOf(meta.getSnapshotId()));
        }
        this.appendInterOpCollection(-1, opCollection);
    }

    public byte[] toPhysicalBytes(Configs configs) throws BuildPhysicalException {
        if (this.ptrPlan == null) {
            throw new BuildPhysicalException("ptrPlan is NullPointer");
        }
        int servers = PegasusConfig.PEGASUS_HOSTS.get(configs).split(",").length;
        int workers = PegasusConfig.PEGASUS_WORKER_NUM.get(configs);
        FfiData.ByValue buffer = irCoreLib.buildPhysicalPlan(this.ptrPlan, workers, servers);
        FfiResult.ByValue error = buffer.error;
        if (error.code != ResultCode.Success) {
            throw new BuildPhysicalException("call libc returns " + error.code.name() + ", msg is " + error.msg);
        }
        byte[] bytes = buffer.getBytes();
        buffer.close();
        return bytes;
    }

    public String getPlanAsJson() throws OpArgIllegalException {
        String json = "";
        if (this.ptrPlan != null) {
            FfiResult.ByValue e = irCoreLib.printPlanAsJson(this.ptrPlan);
            if (e.code != ResultCode.Success) {
                throw new InterOpIllegalArgException(InterOpBase.class, "printPlanAsJson", "code is " + e.code);
            }
            json = e.msg;
        }
        return json;
    }

    @Override
    public void close() {
        if (this.ptrPlan != null) {
            irCoreLib.destroyLogicalPlan(this.ptrPlan);
        }
    }

    private Pair<Integer, Integer> appendInterOpCollection(int parentId, InterOpCollection opCollection) {
        int subTaskRootId = 0;
        int unionParentId = parentId;
        IntByReference oprId = new IntByReference(parentId);
        List<InterOpBase> opList = opCollection.unmodifiableCollection();
        for (int i = 0; i < opList.size(); ++i) {
            InterOpBase op = opList.get(i);
            oprId = this.appendInterOp(oprId.getValue(), op);
            if (i == 0) {
                subTaskRootId = oprId.getValue();
            }
            unionParentId = oprId.getValue();
        }
        return Pair.with((Object)subTaskRootId, (Object)unionParentId);
    }

    private IntByReference appendInterOp(int parentId, InterOpBase base) throws InterOpIllegalArgException, InterOpUnsupportedException, AppendInterOpException {
        FfiResult.ByValue error;
        IntByReference oprId = new IntByReference(parentId);
        if (ClassUtils.equalClass(base, ScanFusionOp.class)) {
            Pointer ptrScan = (Pointer)TransformFactory.SCAN_FUSION_OP.apply(base);
            error = irCoreLib.appendScanOperator(this.ptrPlan, ptrScan, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, SelectOp.class)) {
            Pointer ptrSelect = (Pointer)TransformFactory.SELECT_OP.apply(base);
            error = irCoreLib.appendSelectOperator(this.ptrPlan, ptrSelect, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, ExpandOp.class)) {
            Pointer ptrExpand = (Pointer)TransformFactory.EXPAND_OP.apply(base);
            error = irCoreLib.appendEdgexpdOperator(this.ptrPlan, ptrExpand, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, LimitOp.class)) {
            Pointer ptrLimit = (Pointer)TransformFactory.LIMIT_OP.apply(base);
            error = irCoreLib.appendLimitOperator(this.ptrPlan, ptrLimit, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, ProjectOp.class)) {
            Pointer ptrProject = (Pointer)TransformFactory.PROJECT_OP.apply(base);
            error = irCoreLib.appendProjectOperator(this.ptrPlan, ptrProject, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, OrderOp.class)) {
            Pointer ptrOrder = (Pointer)TransformFactory.ORDER_OP.apply(base);
            error = irCoreLib.appendOrderbyOperator(this.ptrPlan, ptrOrder, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, GroupOp.class)) {
            Pointer ptrGroup = (Pointer)TransformFactory.GROUP_OP.apply(base);
            error = irCoreLib.appendGroupbyOperator(this.ptrPlan, ptrGroup, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, DedupOp.class)) {
            Pointer ptrDedup = (Pointer)TransformFactory.DEDUP_OP.apply(base);
            error = irCoreLib.appendDedupOperator(this.ptrPlan, ptrDedup, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, SinkOp.class)) {
            Pointer ptrSink = (Pointer)TransformFactory.SINK_OP.apply(base);
            error = irCoreLib.appendSinkOperator(this.ptrPlan, ptrSink, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, PathExpandOp.class)) {
            Pointer ptrPathXPd = (Pointer)TransformFactory.PATH_EXPAND_OP.apply(base);
            error = irCoreLib.appendPathxpdOperator(this.ptrPlan, ptrPathXPd, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, GetVOp.class)) {
            Pointer ptrGetV = (Pointer)TransformFactory.GETV_OP.apply(base);
            error = irCoreLib.appendGetvOperator(this.ptrPlan, ptrGetV, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, ApplyOp.class)) {
            ApplyOp applyOp = (ApplyOp)base;
            Optional<OpArg> subOps = applyOp.getSubOpCollection();
            if (!subOps.isPresent()) {
                throw new InterOpIllegalArgException(base.getClass(), "subOpCollection", "is not present in apply");
            }
            InterOpCollection opCollection = (InterOpCollection)subOps.get().applyArg();
            Pair<Integer, Integer> oprIdPair = this.appendInterOpCollection(-1, opCollection);
            applyOp.setSubRootId(new OpArg((Integer)oprIdPair.getValue0(), Function.identity()));
            Pointer ptrApply = (Pointer)TransformFactory.APPLY_OP.apply(base);
            error = irCoreLib.appendApplyOperator(this.ptrPlan, ptrApply, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, UnionOp.class) || ClassUtils.equalClass(base, SubGraphAsUnionOp.class)) {
            UnionOp unionOp = (UnionOp)base;
            Optional<OpArg> subOpsListOpt = unionOp.getSubOpCollectionList();
            if (!subOpsListOpt.isPresent()) {
                throw new InterOpIllegalArgException(base.getClass(), "subOpCollectionList", "is not present in union");
            }
            List subOpsList = (List)subOpsListOpt.get().applyArg();
            if (subOpsList.isEmpty()) {
                throw new InterOpIllegalArgException(base.getClass(), "subOpCollectionList", "is empty in union");
            }
            ArrayList<Object> unionParentIds = new ArrayList<Object>();
            for (InterOpCollection opCollection : subOpsList) {
                Pair<Integer, Integer> oprIdPair = this.appendInterOpCollection(parentId, opCollection);
                unionParentIds.add(oprIdPair.getValue1());
            }
            unionOp.setParentIdList(new OpArg(unionParentIds, Function.identity()));
            Pointer ptrUnion = (Pointer)TransformFactory.UNION_OP.apply(base);
            error = irCoreLib.appendUnionOperator(this.ptrPlan, ptrUnion, oprId);
        } else if (ClassUtils.equalClass(base, MatchOp.class)) {
            Pointer ptrMatch = (Pointer)TransformFactory.MATCH_OP.apply(base);
            error = irCoreLib.appendPatternOperator(this.ptrPlan, ptrMatch, oprId.getValue(), oprId);
        } else if (ClassUtils.equalClass(base, AsNoneOp.class)) {
            Pointer ptrAs = (Pointer)TransformFactory.AS_NONE_OP.apply(base);
            error = irCoreLib.appendAsOperator(this.ptrPlan, ptrAs, oprId.getValue(), oprId);
        } else {
            throw new InterOpUnsupportedException(base.getClass(), "unimplemented yet");
        }
        if (error != null && error.code != ResultCode.Success) {
            throw new AppendInterOpException(base.getClass(), error.code.name() + ", msg is " + error.msg);
        }
        return this.setPostAlias(oprId.getValue(), base);
    }

    private IntByReference setPostAlias(int parentId, InterOpBase base) {
        IntByReference oprId = new IntByReference(parentId);
        if (this.isPostAliasOp(base) && base.getAlias().isPresent()) {
            FfiAlias.ByValue ffiAlias = (FfiAlias.ByValue)((Object)base.getAlias().get().applyArg());
            Pointer ptrAs = irCoreLib.initAsOperator();
            FfiResult.ByValue error = irCoreLib.setAsAlias(ptrAs, ffiAlias);
            if (error != null && error.code != ResultCode.Success) {
                throw new AppendInterOpException(base.getClass(), error.msg);
            }
            FfiResult.ByValue appendOp = irCoreLib.appendAsOperator(this.ptrPlan, ptrAs, parentId, oprId);
            if (appendOp != null && appendOp.code != ResultCode.Success) {
                throw new AppendInterOpException(base.getClass(), appendOp.msg);
            }
        }
        return oprId;
    }

    private boolean isPostAliasOp(InterOpBase base) {
        return base instanceof SelectOp || base instanceof LimitOp || base instanceof OrderOp || base instanceof DedupOp || base instanceof UnionOp;
    }

    private static enum TransformFactory implements Function<InterOpBase, Pointer>
    {
        SCAN_FUSION_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Optional<OpArg> aliasOpt;
                Optional<OpArg> ids;
                ScanFusionOp op = (ScanFusionOp)baseOp;
                Optional<OpArg> scanOpt = op.getScanOpt();
                if (!scanOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "scanOpt", "not present");
                }
                FfiScanOpt ffiScanOpt = (FfiScanOpt)scanOpt.get().applyArg();
                Pointer scan = irCoreLib.initScanOperator(ffiScanOpt);
                Optional<QueryParams> paramsOpt = op.getParams();
                if (paramsOpt.isPresent()) {
                    FfiResult.ByValue e1 = irCoreLib.setScanParams(scan, this.createParams(paramsOpt.get()));
                    if (e1.code != ResultCode.Success) {
                        throw new InterOpIllegalArgException(baseOp.getClass(), "params", "setScanParams returns " + e1.msg);
                    }
                }
                if ((ids = op.getIds()).isPresent()) {
                    Pointer idsPredicate = irCoreLib.initIndexPredicate();
                    List ffiIds = (List)ids.get().applyArg();
                    for (int i = 0; i < ffiIds.size(); ++i) {
                        FfiResult.ByValue e2 = irCoreLib.orEquivPredicate(idsPredicate, ArgUtils.asKey(ArgUtils.ID), (FfiConst.ByValue)((Object)ffiIds.get(i)));
                        if (e2.code == ResultCode.Success) continue;
                        throw new InterOpIllegalArgException(baseOp.getClass(), "ids", "orEquivPredicate returns " + e2.msg);
                    }
                    if (!ffiIds.isEmpty()) {
                        irCoreLib.addScanIndexPredicate(scan, idsPredicate);
                    }
                }
                if ((aliasOpt = baseOp.getAlias()).isPresent()) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)aliasOpt.get().applyArg());
                    irCoreLib.setScanAlias(scan, alias);
                }
                return scan;
            }
        }
        ,
        SELECT_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                SelectOp op = (SelectOp)baseOp;
                Optional<OpArg> predicate = op.getPredicate();
                if (!predicate.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "predicate", "not present");
                }
                String expr = (String)predicate.get().applyArg();
                Pointer select = irCoreLib.initSelectOperator();
                FfiResult.ByValue error = irCoreLib.setSelectPredicate(select, expr);
                if (error.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "predicate", "setSelectPredicate returns " + error.msg);
                }
                return select;
            }
        }
        ,
        EXPAND_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Optional<OpArg> aliasOpt;
                ExpandOp op = (ExpandOp)baseOp;
                Optional<OpArg> direction = op.getDirection();
                if (!direction.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "direction", "not present");
                }
                FfiDirection ffiDirection = (FfiDirection)direction.get().applyArg();
                Optional<OpArg> edgeOpt = op.getExpandOpt();
                if (!edgeOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "edgeOpt", "not present");
                }
                FfiExpandOpt expandOpt = (FfiExpandOpt)edgeOpt.get().applyArg();
                Pointer expand = irCoreLib.initEdgexpdOperator(expandOpt, ffiDirection);
                Optional<QueryParams> paramsOpt = op.getParams();
                if (paramsOpt.isPresent()) {
                    FfiResult.ByValue e1 = irCoreLib.setEdgexpdParams(expand, this.createParams(paramsOpt.get()));
                    if (e1.code != ResultCode.Success) {
                        throw new InterOpIllegalArgException(baseOp.getClass(), "params", "setEdgexpdParams returns " + e1.msg);
                    }
                }
                if ((aliasOpt = baseOp.getAlias()).isPresent() && ClassUtils.equalClass(baseOp, ExpandOp.class)) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)aliasOpt.get().applyArg());
                    irCoreLib.setEdgexpdAlias(expand, alias);
                }
                return expand;
            }
        }
        ,
        LIMIT_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                LimitOp op = (LimitOp)baseOp;
                Optional<OpArg> lower = op.getLower();
                if (!lower.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "lower", "not present");
                }
                Optional<OpArg> upper = op.getUpper();
                if (!upper.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "upper", "not present");
                }
                Pointer ptrLimit = irCoreLib.initLimitOperator();
                FfiResult.ByValue error = irCoreLib.setLimitRange(ptrLimit, (Integer)lower.get().applyArg(), (Integer)upper.get().applyArg());
                if (error.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "lower+upper", "setLimitRange returns " + error.msg);
                }
                return ptrLimit;
            }
        }
        ,
        PROJECT_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                ProjectOp op = (ProjectOp)baseOp;
                Optional<OpArg> exprOpt = op.getExprWithAlias();
                if (!exprOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "exprWithAlias", "not present");
                }
                List exprWithAlias = (List)exprOpt.get().applyArg();
                Pointer ptrProject = irCoreLib.initProjectOperator(true);
                exprWithAlias.forEach(p -> {
                    String expr = (String)p.getValue0();
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)((Object)p.getValue1()));
                    FfiResult.ByValue error = irCoreLib.addProjectExprAlias(ptrProject, expr, alias);
                    if (error.code != ResultCode.Success) {
                        throw new InterOpIllegalArgException(baseOp.getClass(), "exprWithAlias", "append returns " + error.msg);
                    }
                });
                return ptrProject;
            }
        }
        ,
        ORDER_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                OrderOp op = (OrderOp)baseOp;
                Optional<OpArg> varWithOpt = op.getOrderVarWithOrder();
                if (!varWithOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "varWithOrder", "not present");
                }
                List orderList = (List)varWithOpt.get().applyArg();
                if (orderList.isEmpty()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "varWithOrder", "should not be empty");
                }
                Pointer ptrOrder = irCoreLib.initOrderbyOperator();
                orderList.forEach(pair -> {
                    FfiVariable.ByValue var = (FfiVariable.ByValue)((Object)((Object)pair.getValue0()));
                    FfiOrderOpt opt = (FfiOrderOpt)pair.getValue1();
                    irCoreLib.addOrderbyPair(ptrOrder, var, opt);
                });
                Optional<OpArg> lower = op.getLower();
                Optional<OpArg> upper = op.getUpper();
                if (lower.isPresent() && upper.isPresent()) {
                    irCoreLib.setOrderbyLimit(ptrOrder, (Integer)lower.get().applyArg(), (Integer)upper.get().applyArg());
                }
                return ptrOrder;
            }
        }
        ,
        GROUP_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Pointer ptrGroup = irCoreLib.initGroupbyOperator();
                GroupOp op = (GroupOp)baseOp;
                Optional<OpArg> groupKeysOpt = op.getGroupByKeys();
                if (!groupKeysOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "groupKeys", "not present");
                }
                Optional<OpArg> groupValuesOpt = op.getGroupByValues();
                if (!groupValuesOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "groupValues", "not present");
                }
                List groupKeys = (List)groupKeysOpt.get().applyArg();
                groupKeys.forEach(p -> {
                    FfiVariable.ByValue key = (FfiVariable.ByValue)((Object)((Object)p.getValue0()));
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)((Object)p.getValue1()));
                    irCoreLib.addGroupbyKeyAlias(ptrGroup, key, alias);
                });
                List groupValues = (List)groupValuesOpt.get().applyArg();
                if (groupValues.isEmpty()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "groupValues", "not present");
                }
                groupValues.forEach(p -> irCoreLib.addGroupbyAggFn(ptrGroup, p.getVar(), p.getAggregate(), p.getAlias()));
                Optional<OpArg> aliasOpt = baseOp.getAlias();
                if (aliasOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "groupKeys+groupValues", "the query given alias is unsupported");
                }
                return ptrGroup;
            }
        }
        ,
        DEDUP_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Pointer ptrDedup = irCoreLib.initDedupOperator();
                DedupOp op = (DedupOp)baseOp;
                Optional<OpArg> dedupKeysOpt = op.getDedupKeys();
                if (!dedupKeysOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "dedupKeys", "not present");
                }
                List dedupKeys = (List)dedupKeysOpt.get().applyArg();
                if (dedupKeys.isEmpty()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "dedupKeys", "should not be empty if present");
                }
                dedupKeys.forEach(k -> irCoreLib.addDedupKey(ptrDedup, (FfiVariable.ByValue)((Object)k)));
                return ptrDedup;
            }
        }
        ,
        SINK_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Pointer ptrSink;
                SinkOp sinkOp = (SinkOp)baseOp;
                Optional<OpArg> argOpt = sinkOp.getSinkArg();
                if (!argOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "sinkArg", "not present");
                }
                SinkArg sinkArg = (SinkArg)argOpt.get().applyArg();
                if (sinkArg instanceof SinkByColumns) {
                    ptrSink = irCoreLib.initSinkOperator();
                    List<FfiNameOrId.ByValue> columns = ((SinkByColumns)sinkArg).getColumnNames();
                    if (columns.isEmpty()) {
                        throw new InterOpIllegalArgException(baseOp.getClass(), "selected columns", "is empty");
                    }
                    columns.forEach(column -> {
                        FfiResult.ByValue error = irCoreLib.addSinkColumn(ptrSink, (FfiNameOrId.ByValue)((Object)column));
                        if (error.code != ResultCode.Success) {
                            throw new InterOpIllegalArgException(baseOp.getClass(), "columns", "addSinkColumn returns " + error.msg);
                        }
                    });
                } else if (sinkArg instanceof SinkGraph) {
                    String graphName = ((SinkGraph)sinkArg).getConfig("name");
                    ptrSink = irCoreLib.initSinkGraphOperator(graphName);
                } else {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "sink", "target is invalid");
                }
                return ptrSink;
            }
        }
        ,
        PATH_EXPAND_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                PathExpandOp pathOp = (PathExpandOp)baseOp;
                int lower = (Integer)pathOp.getLower().get().applyArg();
                int upper = (Integer)pathOp.getUpper().get().applyArg();
                Pointer expand = (Pointer)EXPAND_OP.apply(baseOp);
                Pointer pathExpand = irCoreLib.initPathxpdOperator(expand, pathOp.getPathOpt(), pathOp.getResultOpt());
                irCoreLib.setPathxpdHops(pathExpand, lower, upper);
                Optional<OpArg> aliasOpt = baseOp.getAlias();
                if (aliasOpt.isPresent()) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)aliasOpt.get().applyArg());
                    irCoreLib.setPathxpdAlias(pathExpand, alias);
                }
                return pathExpand;
            }
        }
        ,
        GETV_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Optional<OpArg> aliasOpt;
                GetVOp getVOp = (GetVOp)baseOp;
                Optional<OpArg> vOpt = getVOp.getGetVOpt();
                if (!vOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "getVOpt", "not present");
                }
                FfiVOpt ffiVOpt = (FfiVOpt)vOpt.get().applyArg();
                Pointer ptrGetV = irCoreLib.initGetvOperator(ffiVOpt);
                Optional<QueryParams> paramsOpt = getVOp.getParams();
                if (paramsOpt.isPresent()) {
                    FfiResult.ByValue e1 = irCoreLib.setGetvParams(ptrGetV, this.createParams(paramsOpt.get()));
                    if (e1.code != ResultCode.Success) {
                        throw new InterOpIllegalArgException(baseOp.getClass(), "params", "setGetvParams returns " + e1.msg);
                    }
                }
                if ((aliasOpt = baseOp.getAlias()).isPresent()) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)aliasOpt.get().applyArg());
                    irCoreLib.setGetvAlias(ptrGetV, alias);
                }
                return ptrGetV;
            }
        }
        ,
        APPLY_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                ApplyOp applyOp = (ApplyOp)baseOp;
                Optional<OpArg> subRootOpt = applyOp.getSubRootId();
                if (!subRootOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "subRootId", "not present");
                }
                Optional<OpArg> joinKindOpt = applyOp.getJoinKind();
                if (!joinKindOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "joinKind", "not present");
                }
                int subRootId = (Integer)subRootOpt.get().applyArg();
                FfiJoinKind joinKind = (FfiJoinKind)joinKindOpt.get().applyArg();
                Pointer ptrApply = irCoreLib.initApplyOperator(subRootId, joinKind);
                Optional<OpArg> aliasOpt = baseOp.getAlias();
                if (aliasOpt.isPresent()) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)aliasOpt.get().applyArg());
                    irCoreLib.setApplyAlias(ptrApply, alias);
                }
                return ptrApply;
            }
        }
        ,
        UNION_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                UnionOp unionOp = (UnionOp)baseOp;
                Optional<OpArg> parentIdsOpt = unionOp.getParentIdList();
                if (!parentIdsOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "parentIdList", "not present");
                }
                List parentIds = (List)parentIdsOpt.get().applyArg();
                if (parentIds.isEmpty()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "parentIdList", "is empty");
                }
                Pointer ptrUnion = irCoreLib.initUnionOperator();
                parentIds.forEach(id -> irCoreLib.addUnionParent(ptrUnion, (int)id));
                return ptrUnion;
            }
        }
        ,
        MATCH_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                MatchOp matchOp = (MatchOp)baseOp;
                List sentences = (List)matchOp.getSentences().get().applyArg();
                if (sentences.isEmpty()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "sentences", "is empty");
                }
                Pointer ptrMatch = irCoreLib.initPatternOperator();
                sentences.forEach(s -> {
                    InterOpCollection ops = s.getBinders();
                    Pointer ptrSentence = irCoreLib.initPatternSentence(s.getJoinKind());
                    irCoreLib.setSentenceStart(ptrSentence, s.getStartTag().alias);
                    irCoreLib.setSentenceEnd(ptrSentence, s.getEndTag().alias);
                    ops.unmodifiableCollection().forEach(o -> {
                        FfiBinderOpt opt;
                        Pointer binder;
                        if (Utils.equalClass(o, ExpandOp.class)) {
                            binder = (Pointer)EXPAND_OP.apply(o);
                            opt = FfiBinderOpt.Edge;
                        } else if (Utils.equalClass(o, PathExpandOp.class)) {
                            binder = (Pointer)PATH_EXPAND_OP.apply(o);
                            opt = FfiBinderOpt.Path;
                        } else if (Utils.equalClass(o, GetVOp.class)) {
                            binder = (Pointer)GETV_OP.apply(o);
                            opt = FfiBinderOpt.Vertex;
                        } else if (Utils.equalClass(o, SelectOp.class)) {
                            binder = (Pointer)SELECT_OP.apply(o);
                            opt = FfiBinderOpt.Select;
                        } else {
                            throw new InterOpIllegalArgException(baseOp.getClass(), "sentences", "binder " + o.getClass() + " is unsupported yet");
                        }
                        irCoreLib.addSentenceBinder(ptrSentence, binder, opt);
                    });
                    irCoreLib.addPatternSentence(ptrMatch, ptrSentence);
                });
                Optional<OpArg> aliasOpt = baseOp.getAlias();
                if (aliasOpt.isPresent()) {
                    throw new InterOpIllegalArgException(baseOp.getClass(), "match", "the query given alias is unsupported");
                }
                return ptrMatch;
            }
        }
        ,
        AS_NONE_OP{

            @Override
            public Pointer apply(InterOpBase baseOp) {
                Pointer asPtr = irCoreLib.initAsOperator();
                FfiResult.ByValue error = irCoreLib.setAsAlias(asPtr, ArgUtils.asNoneAlias());
                if (error != null && error.code != ResultCode.Success) {
                    throw new AppendInterOpException(baseOp.getClass(), error.msg);
                }
                return asPtr;
            }
        };


        public Pointer createParams(QueryParams params) {
            Optional<Double> sampleRatioOpt;
            FfiResult.ByValue error;
            Optional<Pair<Integer, Integer>> rangeOpt;
            FfiResult.ByValue error2;
            Pointer ptrParams = irCoreLib.initQueryParams();
            for (FfiNameOrId.ByValue table : params.getTables()) {
                error2 = irCoreLib.addParamsTable(ptrParams, table);
                if (error2.code == ResultCode.Success) continue;
                throw new InterOpIllegalArgException(InterOpBase.class, "table", "addParamsTable returns " + error2.msg);
            }
            for (FfiNameOrId.ByValue column : params.getColumns()) {
                error2 = irCoreLib.addParamsColumn(ptrParams, column);
                if (error2.code == ResultCode.Success) continue;
                throw new InterOpIllegalArgException(InterOpBase.class, "column", "addParamsColumn returns " + error2.msg);
            }
            Optional<String> predicateOpt = params.getPredicate();
            if (predicateOpt.isPresent()) {
                FfiResult.ByValue error3 = irCoreLib.setParamsPredicate(ptrParams, predicateOpt.get());
                if (error3.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(InterOpBase.class, "predicate", "setParamsPredicate returns " + error3.msg);
                }
            }
            if ((rangeOpt = params.getRange()).isPresent()) {
                Pair<Integer, Integer> range = rangeOpt.get();
                error = irCoreLib.setParamsRange(ptrParams, (Integer)range.getValue0(), (Integer)range.getValue1());
                if (error.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(InterOpBase.class, "range", "setParamsRange returns " + error.msg);
                }
            }
            params.getExtraParams().forEach((k, v) -> {
                FfiResult.ByValue error = irCoreLib.addParamsExtra(ptrParams, (String)k, (String)v);
                if (error.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(InterOpBase.class, "extraParams", "addParamsExtra returns " + error.msg);
                }
            });
            if (params.isAllColumns()) {
                error2 = irCoreLib.setParamsIsAllColumns(ptrParams);
                if (error2.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(InterOpBase.class, "setIsAll", "setParamsIsAllColumns returns " + error2.msg);
                }
            }
            if ((sampleRatioOpt = params.getSampleRatioOpt()).isPresent()) {
                error = irCoreLib.setParamsSampleRatio(ptrParams, sampleRatioOpt.get());
                if (error.code != ResultCode.Success) {
                    throw new InterOpIllegalArgException(InterOpBase.class, "setIsAll", "setParamsSampleRatio returns " + error.msg);
                }
            }
            return ptrParams;
        }
    }
}

