/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.client;

import com.alibaba.graphscope.common.client.RpcChannelFetcher;
import com.alibaba.pegasus.RpcClient;
import com.alibaba.pegasus.intf.CloseableIterator;
import com.alibaba.pegasus.intf.ResultProcessor;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import io.grpc.Status;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcBroadcastProcessor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RpcBroadcastProcessor.class);
    protected RpcClient rpcClient;
    protected RpcChannelFetcher fetcher;

    public RpcBroadcastProcessor(RpcChannelFetcher fetcher) {
        this.fetcher = fetcher;
        if (!fetcher.isDynamic()) {
            this.rpcClient = new RpcClient(fetcher.fetch());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(PegasusClient.JobRequest request, ResultProcessor processor) {
        CloseableIterator iterator = null;
        try {
            if (this.fetcher.isDynamic()) {
                this.rpcClient = new RpcClient(this.fetcher.fetch());
            }
            iterator = this.rpcClient.submit(request);
            while (iterator.hasNext()) {
                PegasusClient.JobResponse response = (PegasusClient.JobResponse)iterator.next();
                processor.process(response);
            }
            processor.finish();
        }
        catch (Throwable e) {
            logger.error("get result from grpc returns error {}", e);
            processor.error(Status.fromThrowable((Throwable)e));
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.close();
                }
                catch (IOException ioe) {
                    logger.error("iterator close fail {}", (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.rpcClient.shutdown();
    }
}

