/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.config;

import com.alibaba.graphscope.common.config.FileLoadType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.NotImplementedException;

public class Configs {
    private Properties properties = new Properties();

    public Configs(String file) throws IOException {
        this(file, FileLoadType.RELATIVE_PATH);
    }

    public Configs(String file, FileLoadType loadType) throws IOException, NotImplementedException {
        switch (loadType) {
            case RELATIVE_PATH: {
                this.properties.load(new FileInputStream(new File(file)));
                break;
            }
            default: {
                throw new NotImplementedException("unimplemented load type " + (Object)((Object)loadType));
            }
        }
        this.properties.keySet().forEach(k -> {
            String trimValue;
            String value = System.getProperty((String)k);
            if (value != null && !(trimValue = value.trim()).isEmpty()) {
                this.properties.setProperty((String)k, trimValue);
            }
        });
    }

    public Configs(Map<String, String> configs) {
        if (configs != null && !configs.isEmpty()) {
            configs.forEach((k, v) -> this.properties.setProperty((String)k, (String)v));
        }
    }

    public String get(String name) {
        return this.properties.getProperty(name);
    }

    public String get(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public String toString() {
        return this.properties.toString();
    }
}

