/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.antlr4;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinGSBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinGSParser;

public class GenericLiteralVisitor
extends GremlinGSBaseVisitor<Object> {
    private static GenericLiteralVisitor instance;

    private GenericLiteralVisitor() {
    }

    public static GenericLiteralVisitor getInstance() {
        if (instance == null) {
            instance = new GenericLiteralVisitor();
        }
        return instance;
    }

    public static String getStringLiteral(GremlinGSParser.StringLiteralContext stringLiteral) {
        return (String)GenericLiteralVisitor.getInstance().visitStringLiteral(stringLiteral);
    }

    public static boolean getBooleanLiteral(GremlinGSParser.BooleanLiteralContext booleanLiteral) {
        return (Boolean)GenericLiteralVisitor.getInstance().visitBooleanLiteral(booleanLiteral);
    }

    public static String[] getStringLiteralList(GremlinGSParser.StringLiteralListContext stringLiteralList) {
        if (stringLiteralList == null || stringLiteralList.stringLiteralExpr() == null) {
            return new String[0];
        }
        return (String[])stringLiteralList.stringLiteralExpr().stringLiteral().stream().filter(Objects::nonNull).map(stringLiteral -> GenericLiteralVisitor.getInstance().visitStringLiteral((GremlinGSParser.StringLiteralContext)((Object)stringLiteral))).toArray(String[]::new);
    }

    public static String[] getStringLiteralExpr(GremlinGSParser.StringLiteralExprContext stringLiteralExpr) {
        return (String[])stringLiteralExpr.stringLiteral().stream().filter(Objects::nonNull).map(stringLiteral -> GenericLiteralVisitor.getInstance().visitStringLiteral((GremlinGSParser.StringLiteralContext)((Object)stringLiteral))).toArray(String[]::new);
    }

    public static Object[] getGenericLiteralList(GremlinGSParser.GenericLiteralListContext objectLiteralList) {
        if (objectLiteralList == null || objectLiteralList.genericLiteralExpr() == null) {
            return new Object[0];
        }
        return objectLiteralList.genericLiteralExpr().genericLiteral().stream().filter(Objects::nonNull).map(genericLiteral -> GenericLiteralVisitor.getInstance().visitGenericLiteral((GremlinGSParser.GenericLiteralContext)((Object)genericLiteral))).toArray(Object[]::new);
    }

    public static Object[] getIntegerLiteralList(GremlinGSParser.IntegerLiteralListContext integerLiteralList) {
        if (integerLiteralList == null || integerLiteralList.integerLiteralExpr() == null) {
            return new Object[0];
        }
        return integerLiteralList.integerLiteralExpr().integerLiteral().stream().filter(Objects::nonNull).map(integerLiteral -> GenericLiteralVisitor.getInstance().visitIntegerLiteral((GremlinGSParser.IntegerLiteralContext)((Object)integerLiteral))).toArray(Object[]::new);
    }

    private static String stripQuotes(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }

    @Override
    public Object visitGenericLiteralList(GremlinGSParser.GenericLiteralListContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Object visitGenericLiteralExpr(GremlinGSParser.GenericLiteralExprContext ctx) {
        int childCount = ctx.getChildCount();
        switch (childCount) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                return this.visitGenericLiteral((GremlinGSParser.GenericLiteralContext)ctx.getChild(0));
            }
        }
        ArrayList<Object> genericLiterals = new ArrayList<Object>();
        for (int childIndex = 0; childIndex < ctx.getChildCount(); childIndex += 2) {
            genericLiterals.add(this.visitGenericLiteral((GremlinGSParser.GenericLiteralContext)ctx.getChild(childIndex)));
        }
        return genericLiterals.toArray();
    }

    @Override
    public Object visitGenericLiteral(GremlinGSParser.GenericLiteralContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Object visitIntegerLiteral(GremlinGSParser.IntegerLiteralContext ctx) {
        int lastCharIndex;
        String integerLiteral = ctx.getText().toLowerCase().replace("_", "");
        if (integerLiteral.charAt(lastCharIndex = integerLiteral.length() - 1) == 'l') {
            integerLiteral = integerLiteral.substring(0, lastCharIndex);
            return Long.decode(integerLiteral);
        }
        try {
            return Integer.decode(integerLiteral);
        }
        catch (NumberFormatException ignoredExpection1) {
            try {
                return Long.decode(integerLiteral);
            }
            catch (NumberFormatException ignoredExpection2) {
                boolean negative;
                int startIndex = 0;
                char firstChar = integerLiteral.charAt(0);
                boolean bl = negative = firstChar == '-';
                if (firstChar == '-' || firstChar == '+') {
                    ++startIndex;
                }
                int radix = 10;
                if (integerLiteral.charAt(startIndex + 1) == 'x') {
                    radix = 16;
                    integerLiteral = integerLiteral.substring(startIndex += 2);
                    if (negative) {
                        integerLiteral = '-' + integerLiteral;
                    }
                } else if (integerLiteral.charAt(startIndex) == '0') {
                    radix = 8;
                }
                return new BigInteger(integerLiteral, radix);
            }
        }
    }

    @Override
    public Object visitFloatLiteral(GremlinGSParser.FloatLiteralContext ctx) {
        String floatLiteral = ctx.getText().toLowerCase();
        char lastCharacter = floatLiteral.charAt(floatLiteral.length() - 1);
        if (Character.isDigit(lastCharacter)) {
            return new BigDecimal(floatLiteral);
        }
        if (lastCharacter == 'f') {
            return new Float(ctx.getText());
        }
        return new Double(floatLiteral);
    }

    @Override
    public Object visitBooleanLiteral(GremlinGSParser.BooleanLiteralContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitStringLiteral(GremlinGSParser.StringLiteralContext ctx) {
        return StringEscapeUtils.unescapeJava((String)GenericLiteralVisitor.stripQuotes(ctx.getText()));
    }

    @Override
    public Object visitNullLiteral(GremlinGSParser.NullLiteralContext ctx) {
        return null;
    }
}

