/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.auth;

import com.alibaba.graphscope.gremlin.auth.AuthManager;
import com.alibaba.graphscope.gremlin.auth.AuthManagerReference;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthenticator.class);
    private AuthManager authManager;

    public boolean requireAuthentication() {
        return this.authManager.requireAuthentication();
    }

    public void setup(Map<String, Object> config) {
        this.authManager = (AuthManager)Preconditions.checkNotNull((Object)AuthManagerReference.getAuthManager());
    }

    public final Authenticator.SaslNegotiator newSaslNegotiator(InetAddress remoteAddress) {
        return new PlainTextSaslAuthenticator();
    }

    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        String username = credentials.get("username");
        String password = credentials.get("password");
        return this.authManager.authenticate(username, password);
    }

    private class PlainTextSaslAuthenticator
    implements Authenticator.SaslNegotiator {
        private boolean complete = false;
        private String username;
        private String password;

        private PlainTextSaslAuthenticator() {
        }

        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            this.decodeCredentials(clientResponse);
            this.complete = true;
            return null;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!this.complete) {
                throw new AuthenticationException("SASL negotiation not complete");
            }
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", this.username);
            credentials.put("password", this.password);
            return DefaultAuthenticator.this.authenticate(credentials);
        }

        private void decodeCredentials(byte[] bytes) throws AuthenticationException {
            byte[] user = null;
            byte[] pass = null;
            int end = bytes.length;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] != 0) continue;
                if (pass == null) {
                    pass = Arrays.copyOfRange(bytes, i + 1, end);
                } else if (user == null) {
                    user = Arrays.copyOfRange(bytes, i + 1, end);
                }
                end = i;
            }
            if (null == user) {
                throw new AuthenticationException("Authentication ID must not be null");
            }
            if (null == pass) {
                throw new AuthenticationException("Password must not be null");
            }
            this.username = new String(user, StandardCharsets.UTF_8);
            this.password = new String(pass, StandardCharsets.UTF_8);
        }
    }
}

