/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.integration.processor;

import com.alibaba.graphscope.common.client.RpcChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.common.store.IrMetaFetcher;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.integration.result.GremlinTestResultProcessor;
import com.alibaba.graphscope.gremlin.plugin.processor.IrStandardOpProcessor;
import com.alibaba.graphscope.gremlin.plugin.script.AntlrToJavaScriptEngine;
import com.alibaba.graphscope.gremlin.result.GremlinResultAnalyzer;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.translator.GroovyTranslator;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.op.traversal.TraversalOpProcessor;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrTestOpProcessor
extends IrStandardOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TraversalOpProcessor.class);
    private AntlrToJavaScriptEngine scriptEngine;
    private ScriptContext context = new SimpleScriptContext();
    private GraphProperties testGraph;

    public IrTestOpProcessor(Configs configs, IrMetaFetcher irMetaFetcher, RpcChannelFetcher fetcher, IrMetaQueryCallback metaQueryCallback, Graph graph, GraphTraversalSource g, GraphProperties testGraph) {
        super(configs, irMetaFetcher, fetcher, metaQueryCallback, graph, g);
        SimpleBindings globalBindings = new SimpleBindings();
        globalBindings.put("g", (Object)g);
        this.context.setBindings(globalBindings, 100);
        this.scriptEngine = new AntlrToJavaScriptEngine();
        this.testGraph = testGraph;
    }

    public String getName() {
        return "traversal";
    }

    public ThrowingConsumer<Context> select(Context ctx) {
        RequestMessage message = ctx.getRequestMessage();
        logger.debug("tokens ops is {}", (Object)message.getOp());
        switch (message.getOp()) {
            case "bytecode": {
                ThrowingConsumer op = context -> {
                    Bytecode byteCode = (Bytecode)message.getArgs().get("gremlin");
                    String script = this.getScript(byteCode);
                    Traversal traversal = (Traversal)this.scriptEngine.eval(script, this.context);
                    IrTestOpProcessor.applyStrategies(traversal);
                    long jobId = JOB_ID_COUNTER.incrementAndGet();
                    this.processTraversal(traversal, new GremlinTestResultProcessor(ctx, GremlinResultAnalyzer.analyze(traversal), this.testGraph), jobId, script);
                };
                return op;
            }
        }
        RequestMessage msg = ctx.getRequestMessage();
        String errorMsg = message.getOp() + " is unsupported";
        ctx.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_EVALUATION).statusMessage(errorMsg).create());
        return null;
    }

    public void close() throws Exception {
        this.broadcastProcessor.close();
    }

    private String getScript(Bytecode byteCode) {
        String script = GroovyTranslator.of((String)"g").translate(byteCode).getScript();
        List<String> typeCastStrs = Arrays.asList("\\(int\\)", "\\(long\\)", "\\(double\\)", "\\(boolean\\)");
        for (String type : typeCastStrs) {
            script = script.replaceAll(type, "");
        }
        return script;
    }
}

