/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.integration.result;

import com.alibaba.graphscope.common.client.ResultParser;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.result.GremlinResultProcessor;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinTestResultProcessor
extends GremlinResultProcessor {
    private static Logger logger = LoggerFactory.getLogger(GremlinTestResultProcessor.class);
    private Map<String, Object> cachedProperties;
    private static String VERTEX_PROPERTIES = "vertex_properties";
    private static String EDGE_PROPERTIES = "edge_properties";

    public GremlinTestResultProcessor(Context writeResult, ResultParser resultParser, GraphProperties testGraph) {
        super(writeResult, resultParser);
        this.cachedProperties = testGraph.getProperties();
    }

    @Override
    protected void formatResultIfNeed() {
        super.formatResultIfNeed();
        List testTraversers = this.resultCollectors.stream().map(k -> {
            if (k instanceof DetachedVertex) {
                DetachedVertex vertex = (DetachedVertex)k;
                return new DetachedVertex(vertex.id(), vertex.label(), this.getVertexProperties((Vertex)vertex));
            }
            if (k instanceof DetachedEdge) {
                DetachedEdge edge = (DetachedEdge)k;
                Vertex outVertex = edge.outVertex();
                Vertex inVertex = edge.inVertex();
                return new DetachedEdge(edge.id(), edge.label(), this.getEdgeProperties((Edge)edge), outVertex.id(), outVertex.label(), inVertex.id(), inVertex.label());
            }
            return k;
        }).map(k -> new DefaultRemoteTraverser(k, 1L)).collect(Collectors.toList());
        this.resultCollectors.clear();
        this.resultCollectors.addAll(testTraversers);
    }

    private Map<String, Object> getVertexProperties(Vertex vertex) {
        String idAsStr;
        Map vertexProperties = (Map)this.cachedProperties.get(VERTEX_PROPERTIES);
        Map properties = (Map)vertexProperties.get(idAsStr = String.valueOf(vertex.id()));
        if (properties != null) {
            HashMap<String, Object> formatProperties = new HashMap<String, Object>();
            properties.forEach((k, v) -> formatProperties.put((String)k, Collections.singletonList(ImmutableMap.of((Object)"id", (Object)1L, (Object)"value", (Object)v))));
            return formatProperties;
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> getEdgeProperties(Edge edge) {
        String idAsStr;
        Map edgeProperties = (Map)this.cachedProperties.get(EDGE_PROPERTIES);
        Map properties = (Map)edgeProperties.get(idAsStr = String.valueOf(edge.id()));
        return properties == null ? Collections.emptyMap() : properties;
    }
}

