/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.script;

import com.alibaba.graphscope.gremlin.antlr4.GremlinAntlrToJava;
import com.alibaba.graphscope.gremlin.exception.InvalidGremlinScriptException;
import com.alibaba.graphscope.gremlin.plugin.script.AntlrToJavaScriptEngineFactory;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinGSLexer;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinGSParser;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntlrToJavaScriptEngine
extends AbstractScriptEngine
implements GremlinScriptEngine {
    private Logger logger = LoggerFactory.getLogger(AntlrToJavaScriptEngine.class);
    private volatile AntlrToJavaScriptEngineFactory factory;

    @Override
    public Object eval(String script, ScriptContext ctx) {
        this.logger.debug("antlr start to eval \"{}\"", (Object)script);
        Bindings globalBindings = ctx.getBindings(100);
        GraphTraversalSource g = (GraphTraversalSource)globalBindings.get("g");
        GremlinAntlrToJava antlrToJava = GremlinAntlrToJava.getInstance(g);
        try {
            GremlinGSLexer lexer = new GremlinGSLexer((CharStream)CharStreams.fromString((String)script));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    throw new ParseCancellationException();
                }
            });
            GremlinGSParser parser = new GremlinGSParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return antlrToJava.visit((ParseTree)parser.query());
        }
        catch (ParseCancellationException e) {
            Throwable t = ExceptionUtils.getRootCause((Throwable)e);
            String error = String.format("query [%s] is invalid, check the grammar in GremlinGS.g4, ", script);
            if (t instanceof LexerNoViableAltException) {
                error = error + String.format("failed at index: %s.", ((LexerNoViableAltException)t).getStartIndex());
            } else if (t instanceof NoViableAltException) {
                error = error + String.format("token: %s.", ((NoViableAltException)t).getStartToken().toString());
            } else if (t == null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                error = error + String.format("message: %s, stacktrace: %s.", e.toString(), sw.toString());
            } else {
                error = error + String.format("message: %s.", t.getMessage());
            }
            throw new InvalidGremlinScriptException(error);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) {
        throw new NotImplementedException("use eval(String, ScriptContext) instead");
    }

    public Traversal.Admin eval(Bytecode bytecode, Bindings bindings, String traversalSource) {
        throw new NotImplementedException("use eval(String, ScriptContext) instead");
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GremlinScriptEngineFactory getFactory() {
        if (this.factory == null) {
            AntlrToJavaScriptEngine antlrToJavaScriptEngine = this;
            synchronized (antlrToJavaScriptEngine) {
                if (this.factory == null) {
                    this.factory = new AntlrToJavaScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }
}

