/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.step;

import com.alibaba.graphscope.common.jna.type.PathOpt;
import com.alibaba.graphscope.common.jna.type.ResultOpt;
import com.alibaba.graphscope.gremlin.exception.ExtendGremlinStepException;
import com.alibaba.graphscope.gremlin.plugin.step.ExpandFusionStep;
import com.google.common.base.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class PathExpandStep
extends ExpandFusionStep<Vertex> {
    private Traversal rangeTraversal;
    private PathOpt pathOpt;
    private ResultOpt resultOpt;

    public PathExpandStep(Traversal.Admin traversal, Direction direction, Traversal rangeTraversal, String ... edgeLabels) {
        super(traversal, Vertex.class, direction, edgeLabels);
        this.rangeTraversal = rangeTraversal;
        this.pathOpt = PathOpt.Arbitrary;
        this.resultOpt = ResultOpt.EndV;
    }

    public int getLower() {
        Traversal.Admin admin = this.rangeTraversal.asAdmin();
        if (admin.getSteps().size() == 1 && admin.getStartStep() instanceof RangeGlobalStep) {
            RangeGlobalStep range = (RangeGlobalStep)admin.getStartStep();
            return (int)range.getLowRange();
        }
        throw new ExtendGremlinStepException("rangeTraversal should only have one RangeGlobalStep");
    }

    public int getUpper() {
        Traversal.Admin admin = this.rangeTraversal.asAdmin();
        if (admin.getSteps().size() == 1 && admin.getStartStep() instanceof RangeGlobalStep) {
            RangeGlobalStep range = (RangeGlobalStep)admin.getStartStep();
            return (int)range.getHighRange();
        }
        throw new ExtendGremlinStepException("rangeTraversal should only have one RangeGlobalStep");
    }

    public PathOpt getPathOpt() {
        return this.pathOpt;
    }

    public ResultOpt getResultOpt() {
        return this.resultOpt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Object ... keyValues) {
        String originalKey = (String)keyValues[0];
        String originalVal = (String)keyValues[1];
        String key = this.toCamelCaseInsensitive(originalKey);
        String value = this.toCamelCaseInsensitive(originalVal);
        if (key.equals("PathOpt")) {
            if (!value.equals("Arbitrary") && !value.equals("Simple")) throw new ExtendGremlinStepException("value " + originalVal + " is invalid, use ARBITRARY or SIMPLE instead (case insensitive)");
            this.pathOpt = PathOpt.valueOf(value);
            return;
        } else {
            if (!key.equals("ResultOpt")) throw new ExtendGremlinStepException("key " + originalKey + " is invalid, use PATH_OPT or RESULT_OPT instead (case insensitive)");
            if (!value.equals("AllV") && !value.equals("EndV")) throw new ExtendGremlinStepException("value " + originalVal + " is invalid, use ALL_V or END_V instead (case insensitive)");
            this.resultOpt = ResultOpt.valueOf(value);
        }
    }

    private String toCamelCaseInsensitive(String underscore) {
        String[] splits = underscore.split("_");
        String camelCase = "";
        for (int i = 0; i < splits.length; ++i) {
            String split = splits[i];
            camelCase = camelCase + (split.isEmpty() ? split : Character.toUpperCase(split.charAt(0)) + split.substring(1).toLowerCase());
        }
        return camelCase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathExpandStep that = (PathExpandStep)((Object)o);
        return Objects.equal((Object)this.rangeTraversal, (Object)that.rangeTraversal) && this.pathOpt == that.pathOpt && this.resultOpt == that.resultOpt;
    }

    @Override
    public String toString() {
        return "PathExpandStep{rangeTraversal=" + this.rangeTraversal + ", pathOpt=" + this.pathOpt + ", resultOpt=" + this.resultOpt + '}';
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.rangeTraversal, this.pathOpt, this.resultOpt});
    }
}

