/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.plugin.strategy;

import com.alibaba.graphscope.gremlin.plugin.step.ScanFusionStep;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.CoinStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public class ScanFusionStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final ScanFusionStepStrategy INSTANCE = new ScanFusionStepStrategy();

    private ScanFusionStepStrategy() {
    }

    public static ScanFusionStepStrategy instance() {
        return INSTANCE;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        for (GraphStep originalGraphStep : TraversalHelper.getStepsOfClass(GraphStep.class, traversal)) {
            ScanFusionStep scanFusionStep = new ScanFusionStep(originalGraphStep);
            TraversalHelper.replaceStep((Step)originalGraphStep, scanFusionStep, traversal);
            Step currentStep = scanFusionStep.getNextStep();
            while (currentStep instanceof HasStep || currentStep instanceof NoOpBarrierStep) {
                if (currentStep instanceof HasStep) {
                    List originalContainers = ((HasContainerHolder)currentStep).getHasContainers();
                    for (HasContainer hasContainer : originalContainers) {
                        if (GraphStep.processHasContainerIds(scanFusionStep, (HasContainer)hasContainer) || ScanFusionStep.processHasLabels(scanFusionStep, hasContainer, originalContainers)) continue;
                        scanFusionStep.addHasContainer(hasContainer);
                    }
                    TraversalHelper.copyLabels((Step)currentStep, (Step)currentStep.getPreviousStep(), (boolean)false);
                    traversal.removeStep(currentStep);
                }
                currentStep = currentStep.getNextStep();
            }
            if (!(currentStep instanceof CoinStep)) continue;
            scanFusionStep.setCoinStep((CoinStep)currentStep);
            TraversalHelper.copyLabels((Step)currentStep, (Step)currentStep.getPreviousStep(), (boolean)false);
            traversal.removeStep(currentStep);
        }
    }
}

