/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.result;

import com.alibaba.graphscope.common.jna.type.FfiKeyType;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gaia.proto.OuterExpression;
import com.alibaba.graphscope.gremlin.exception.GremlinResultParserException;
import com.alibaba.graphscope.gremlin.result.EmptyValue;
import com.alibaba.graphscope.gremlin.result.GremlinResultParser;
import com.alibaba.graphscope.gremlin.result.ParserUtils;
import com.alibaba.graphscope.gremlin.transform.alias.AliasManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GremlinResultParserFactory implements GremlinResultParser
{
    GRAPH_ELEMENT{

        @Override
        public Object parseFrom(IrResult.Results results) {
            IrResult.Element element = ParserUtils.getHeadEntry(results).getElement();
            Object graphElement = ParserUtils.parseElement(element);
            if (!(graphElement instanceof Element) && !(graphElement instanceof List)) {
                throw new GremlinResultParserException("parse element should return vertex or edge or graph path");
            }
            return graphElement;
        }
    }
    ,
    SINGLE_VALUE{

        @Override
        public Object parseFrom(IrResult.Results results) {
            IrResult.Entry entry = ParserUtils.getHeadEntry(results);
            return ParserUtils.parseEntry(entry);
        }
    }
    ,
    PROJECT_VALUE{

        @Override
        public Object parseFrom(IrResult.Results results) {
            logger.debug("{}", (Object)results);
            IrResult.Record record = results.getRecord();
            logger.debug("{}", (Object)record);
            HashMap projectResult = new HashMap();
            record.getColumnsList().forEach(column -> {
                String tag = this.getColumnKeyAsResultKey(column.getNameOrId());
                Object parseEntry = ParserUtils.parseEntry(column.getEntry());
                if (parseEntry instanceof Map) {
                    Map projectTags = (Map)parseEntry;
                    Map tagEntry = (Map)projectResult.computeIfAbsent(tag, k1 -> new HashMap());
                    projectTags.forEach((k, v) -> {
                        if (!(v instanceof EmptyValue)) {
                            String nameOrId = null;
                            if (k instanceof List) {
                                nameOrId = (String)((List)k).get(1);
                            } else if (k instanceof String) {
                                nameOrId = (String)k;
                            } else if (k instanceof Number) {
                                nameOrId = String.valueOf(k);
                            }
                            if (nameOrId == null || nameOrId.isEmpty()) {
                                throw new GremlinResultParserException("map value should have property key");
                            }
                            String property = this.getPropertyName(nameOrId);
                            tagEntry.put(property, Collections.singletonList(v));
                        }
                    });
                } else if (!(parseEntry instanceof EmptyValue)) {
                    projectResult.put(tag, parseEntry);
                }
            });
            if (projectResult.isEmpty()) {
                return EmptyValue.INSTANCE;
            }
            if (projectResult.size() == 1) {
                return projectResult.entrySet().iterator().next().getValue();
            }
            return projectResult;
        }

        private String getColumnKeyAsResultKey(OuterExpression.NameOrId columnKey) {
            if (columnKey.getItemCase() == OuterExpression.NameOrId.ItemCase.ITEM_NOT_SET) {
                return "";
            }
            switch (columnKey.getItemCase()) {
                case ITEM_NOT_SET: {
                    return "";
                }
                case NAME: {
                    String key = columnKey.getName();
                    return AliasManager.getPrefix(key);
                }
                case ID: {
                    return String.valueOf(columnKey.getId());
                }
            }
            throw new GremlinResultParserException((Object)((Object)columnKey.getItemCase()) + " is invalid");
        }

        private String getPropertyName(String nameOrId) {
            OuterExpression.NameOrId.Builder builder = OuterExpression.NameOrId.newBuilder();
            if (nameOrId.matches("^[0-9]+$")) {
                builder.setId(Integer.valueOf(nameOrId));
            } else {
                builder.setName(nameOrId);
            }
            return ParserUtils.getKeyName(builder.build(), FfiKeyType.Column);
        }
    }
    ,
    UNION{

        @Override
        public Object parseFrom(IrResult.Results results) {
            GremlinResultParser resultParser = this.inferFromIrResults(results);
            return resultParser.parseFrom(results);
        }

        private GremlinResultParser inferFromIrResults(IrResult.Results results) {
            int columns = results.getRecord().getColumnsList().size();
            logger.debug("result is {}", (Object)results);
            if (columns == 1) {
                IrResult.Entry entry = ParserUtils.getHeadEntry(results);
                switch (entry.getInnerCase()) {
                    case ELEMENT: {
                        IrResult.Element element = entry.getElement();
                        if (element.getInnerCase() == IrResult.Element.InnerCase.VERTEX || element.getInnerCase() == IrResult.Element.InnerCase.EDGE || element.getInnerCase() == IrResult.Element.InnerCase.GRAPH_PATH) {
                            return GRAPH_ELEMENT;
                        }
                        if (element.getInnerCase() == IrResult.Element.InnerCase.OBJECT) {
                            Common.Value value = element.getObject();
                            if (value.getItemCase() == Common.Value.ItemCase.PAIR_ARRAY) {
                                return PROJECT_VALUE;
                            }
                            return SINGLE_VALUE;
                        }
                        throw new GremlinResultParserException((Object)((Object)element.getInnerCase()) + " is invalid");
                    }
                }
                throw new GremlinResultParserException((Object)((Object)entry.getInnerCase()) + " is unsupported yet");
            }
            if (columns > 1) {
                return PROJECT_VALUE;
            }
            throw new GremlinResultParserException("columns should not be empty");
        }
    }
    ,
    SUBGRAPH{

        @Override
        public Object parseFrom(IrResult.Results results) {
            return EmptyValue.INSTANCE;
        }
    };

    private static Logger logger;

    static {
        logger = LoggerFactory.getLogger(GremlinResultParserFactory.class);
    }
}

