/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.result;

import com.alibaba.graphscope.common.jna.IrCoreLibrary;
import com.alibaba.graphscope.common.jna.type.FfiKeyType;
import com.alibaba.graphscope.common.jna.type.FfiResult;
import com.alibaba.graphscope.common.jna.type.ResultCode;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.alibaba.graphscope.gaia.proto.OuterExpression;
import com.alibaba.graphscope.gremlin.exception.GremlinResultParserException;
import com.alibaba.graphscope.gremlin.result.EmptyValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParserUtils.class);
    private static final IrCoreLibrary irCoreLib = IrCoreLibrary.INSTANCE;

    public static Object parseElement(IrResult.Element element) {
        switch (element.getInnerCase()) {
            case VERTEX: {
                return ParserUtils.parseVertex(element.getVertex());
            }
            case EDGE: {
                return ParserUtils.parseEdge(element.getEdge());
            }
            case GRAPH_PATH: {
                IrResult.GraphPath graphPath = element.getGraphPath();
                return graphPath.getPathList().stream().map(k -> {
                    if (k.getInnerCase() == IrResult.GraphPath.VertexOrEdge.InnerCase.VERTEX) {
                        return ParserUtils.parseVertex(k.getVertex());
                    }
                    if (k.getInnerCase() == IrResult.GraphPath.VertexOrEdge.InnerCase.EDGE) {
                        return ParserUtils.parseEdge(k.getEdge());
                    }
                    throw new GremlinResultParserException((Object)((Object)k.getInnerCase()) + " is invalid");
                }).collect(Collectors.toList());
            }
            case OBJECT: {
                return ParserUtils.parseCommonValue(element.getObject());
            }
        }
        throw new GremlinResultParserException((Object)((Object)element.getInnerCase()) + " is invalid");
    }

    public static List<Object> parseCollection(IrResult.Collection collection) {
        return collection.getCollectionList().stream().map(k -> ParserUtils.parseElement(k)).collect(Collectors.toList());
    }

    public static IrResult.Entry getHeadEntry(IrResult.Results results) {
        return results.getRecord().getColumns(0).getEntry();
    }

    private static Object parseCommonValue(Common.Value value) {
        switch (value.getItemCase()) {
            case BOOLEAN: {
                return value.getBoolean();
            }
            case I32: {
                return value.getI32();
            }
            case I64: {
                return value.getI64();
            }
            case F64: {
                return value.getF64();
            }
            case STR: {
                return value.getStr();
            }
            case PAIR_ARRAY: {
                Common.PairArray pairs = value.getPairArray();
                HashMap pairInMap = new HashMap();
                pairs.getItemList().forEach(pair -> pairInMap.put(ParserUtils.parseCommonValue(pair.getKey()), ParserUtils.parseCommonValue(pair.getVal())));
                return pairInMap;
            }
            case STR_ARRAY: {
                return value.getStrArray().getItemList();
            }
            case NONE: {
                return EmptyValue.INSTANCE;
            }
        }
        throw new GremlinResultParserException((Object)((Object)value.getItemCase()) + " is unsupported yet");
    }

    private static Vertex parseVertex(IrResult.Vertex vertex) {
        Map<String, Object> properties = ParserUtils.parseProperties(vertex.getPropertiesList());
        return new DetachedVertex((Object)vertex.getId(), ParserUtils.getKeyName(vertex.getLabel(), FfiKeyType.Entity), properties);
    }

    private static Edge parseEdge(IrResult.Edge edge) {
        Map<String, Object> edgeProperties = ParserUtils.parseProperties(edge.getPropertiesList());
        return new DetachedEdge((Object)edge.getId(), ParserUtils.getKeyName(edge.getLabel(), FfiKeyType.Relation), edgeProperties, (Object)edge.getSrcId(), ParserUtils.getKeyName(edge.getSrcLabel(), FfiKeyType.Entity), (Object)edge.getDstId(), ParserUtils.getKeyName(edge.getDstLabel(), FfiKeyType.Entity));
    }

    private static Map<String, Object> parseProperties(List<IrResult.Property> properties) {
        return new HashMap<String, Object>();
    }

    public static String getKeyName(OuterExpression.NameOrId key, FfiKeyType type) {
        switch (key.getItemCase()) {
            case NAME: {
                return key.getName();
            }
            case ID: {
                FfiResult.ByValue result = irCoreLib.getKeyName(key.getId(), type);
                if (result.code != ResultCode.Success) {
                    String errorMsg = "code is " + result.code.name() + ", msg is " + result.msg;
                    throw new GremlinResultParserException("getKeyName fail " + errorMsg);
                }
                return result.msg;
            }
        }
        logger.error("{}", (Object)"key type is not set");
        return "";
    }

    public static Object parseEntry(IrResult.Entry entry) {
        switch (entry.getInnerCase()) {
            case ELEMENT: {
                return ParserUtils.parseElement(entry.getElement());
            }
            case COLLECTION: {
                List<Object> elements = ParserUtils.parseCollection(entry.getCollection());
                List notNull = elements.stream().filter(k -> !(k instanceof EmptyValue)).collect(Collectors.toList());
                return notNull.isEmpty() ? EmptyValue.INSTANCE : notNull;
            }
        }
        throw new GremlinResultParserException("invalid " + entry.getInnerCase().name());
    }
}

