/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.gremlin.service;

import com.alibaba.graphscope.common.client.RpcChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.manager.IrMetaQueryCallback;
import com.alibaba.graphscope.common.store.IrMetaFetcher;
import com.alibaba.graphscope.gremlin.Utils;
import com.alibaba.graphscope.gremlin.auth.AuthManagerReference;
import com.alibaba.graphscope.gremlin.auth.DefaultAuthManager;
import com.alibaba.graphscope.gremlin.integration.processor.IrTestOpProcessor;
import com.alibaba.graphscope.gremlin.integration.result.GraphProperties;
import com.alibaba.graphscope.gremlin.plugin.processor.IrOpLoader;
import com.alibaba.graphscope.gremlin.plugin.processor.IrStandardOpProcessor;
import com.alibaba.graphscope.gremlin.plugin.traversal.IrCustomizedTraversalSource;
import io.netty.channel.Channel;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerFactory;

public class IrGremlinServer
implements AutoCloseable {
    private GremlinServer gremlinServer;
    private Settings settings;
    private Graph graph;
    private GraphTraversalSource g;

    public IrGremlinServer() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/gremlin-server.yaml");
        this.settings = Settings.read((InputStream)input);
        this.settings.host = "0.0.0.0";
        this.graph = TinkerFactory.createModern();
        this.g = (GraphTraversalSource)this.graph.traversal(IrCustomizedTraversalSource.class);
    }

    public IrGremlinServer(int gremlinPort) {
        this();
        this.settings.port = gremlinPort >= 0 ? gremlinPort : this.settings.port;
    }

    public void start(Configs configs, IrMetaFetcher irMetaFetcher, RpcChannelFetcher fetcher, IrMetaQueryCallback metaQueryCallback, GraphProperties testGraph) throws Exception {
        IrStandardOpProcessor standardProcessor = new IrStandardOpProcessor(configs, irMetaFetcher, fetcher, metaQueryCallback, this.graph, this.g);
        IrOpLoader.addProcessor(standardProcessor.getName(), (OpProcessor)standardProcessor);
        IrTestOpProcessor testProcessor = new IrTestOpProcessor(configs, irMetaFetcher, fetcher, metaQueryCallback, this.graph, this.g, testGraph);
        IrOpLoader.addProcessor(testProcessor.getName(), (OpProcessor)testProcessor);
        DefaultAuthManager authManager = new DefaultAuthManager(configs);
        AuthManagerReference.setAuthManager(authManager);
        this.gremlinServer = new GremlinServer(this.settings);
        ServerGremlinExecutor serverGremlinExecutor = (ServerGremlinExecutor)Utils.getFieldValue(GremlinServer.class, this.gremlinServer, "serverGremlinExecutor");
        serverGremlinExecutor.getGraphManager().putGraph("graph", this.graph);
        serverGremlinExecutor.getGraphManager().putTraversalSource("g", (TraversalSource)this.graph.traversal());
        this.gremlinServer.start().join();
    }

    @Override
    public void close() throws Exception {
        if (this.gremlinServer != null) {
            this.gremlinServer.stop();
        }
    }

    public int getGremlinServerPort() throws Exception {
        Field ch = this.gremlinServer.getClass().getDeclaredField("ch");
        ch.setAccessible(true);
        Channel o = (Channel)ch.get(this.gremlinServer);
        SocketAddress localAddr = o.localAddress();
        return ((InetSocketAddress)localAddr).getPort();
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinServer.getServerGremlinExecutor().getGremlinExecutor();
    }
}

