/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus;

import com.alibaba.pegasus.RpcChannel;
import com.alibaba.pegasus.RpcClient;
import com.alibaba.pegasus.builder.JobBuilder;
import com.alibaba.pegasus.intf.CloseableIterator;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExample {
    private static final Logger logger = LoggerFactory.getLogger(ClientExample.class);

    private static void process(PegasusClient.JobResponse response) {
        ByteString data = response.getResp();
        ArrayList<Long> res = ClientExample.toLongArray(data.toByteArray(), data.size());
        logger.info("got one response: job id {}, array size {}, job data {}", new Object[]{response.getJobId(), res.size(), res.toString()});
    }

    private static void finish() {
        logger.info("finish process");
    }

    private static void error(Status status) {
        logger.error("on error {}", (Object)status.toString());
    }

    private static ArrayList<Long> toLongArray(byte[] bytes, int size) {
        ArrayList<Long> res = new ArrayList<Long>();
        for (int i = 0; i < size; i += 8) {
            long l = ClientExample.fromByteArray(Arrays.copyOfRange(bytes, i, i + 8));
            res.add(l);
        }
        return res;
    }

    private static byte[] toByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    private static long fromByteArray(byte[] bytes) {
        return ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }

    private static ByteString getSeed(long a) {
        return ByteString.copyFrom((byte[])ClientExample.toByteArray(a));
    }

    private static ByteString getRoute() {
        return ByteString.EMPTY;
    }

    private static ByteString add(long a) {
        return ByteString.copyFrom((byte[])ClientExample.toByteArray(a));
    }

    private static ByteString copy(long a) {
        return ByteString.copyFrom((byte[])ClientExample.toByteArray(a));
    }

    private static ByteString getSink() {
        return ByteString.EMPTY;
    }

    public static void main(String[] args) throws Exception {
        RpcChannel rpcChannel0 = new RpcChannel("localhost", 1234);
        RpcChannel rpcChannel1 = new RpcChannel("localhost", 1235);
        ArrayList<RpcChannel> channels = new ArrayList<RpcChannel>();
        channels.add(rpcChannel0);
        channels.add(rpcChannel1);
        RpcClient rpcClient = new RpcClient(channels);
        logger.info("Will try to send request");
        PegasusClient.JobConfig confPb = PegasusClient.JobConfig.newBuilder().setJobId(2L).setJobName("ping_pong_example").setWorkers(2).setAll(PegasusClient.Empty.newBuilder().build()).build();
        JobBuilder jobBuilder = new JobBuilder(confPb);
        JobBuilder start = new JobBuilder();
        jobBuilder.addSource(ClientExample.getSeed(0L)).repeat(3, start.exchange(ClientExample.getRoute()).map(ClientExample.add(1L)).flatMap(ClientExample.copy(8L))).sink(ClientExample.getSink());
        PegasusClient.JobRequest req = jobBuilder.build();
        CloseableIterator<PegasusClient.JobResponse> iterator = rpcClient.submit(req);
        try {
            while (iterator.hasNext()) {
                PegasusClient.JobResponse response = (PegasusClient.JobResponse)iterator.next();
                ClientExample.process(response);
            }
        }
        catch (Exception e) {
            if (iterator != null) {
                try {
                    iterator.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ClientExample.error(Status.fromThrowable((Throwable)e));
            throw e;
        }
        ClientExample.finish();
        rpcClient.shutdown();
    }
}

