/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus;

import com.alibaba.pegasus.RpcChannel;
import com.alibaba.pegasus.common.StreamIterator;
import com.alibaba.pegasus.intf.CloseableIterator;
import com.alibaba.pegasus.service.protocol.JobServiceGrpc;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient {
    private static final Logger logger = LoggerFactory.getLogger(RpcClient.class);
    private List<RpcChannel> channels;

    public RpcClient(List<RpcChannel> channels) {
        this.channels = channels;
    }

    public CloseableIterator<PegasusClient.JobResponse> submit(PegasusClient.JobRequest jobRequest) throws InterruptedException {
        StreamIterator<PegasusClient.JobResponse> responseIterator = new StreamIterator<PegasusClient.JobResponse>();
        AtomicInteger counter = new AtomicInteger(this.channels.size());
        AtomicBoolean finished = new AtomicBoolean(false);
        for (RpcChannel rpcChannel : this.channels) {
            JobServiceGrpc.JobServiceStub asyncStub = JobServiceGrpc.newStub((Channel)rpcChannel.getChannel());
            ((JobServiceGrpc.JobServiceStub)asyncStub.withDeadlineAfter(600000L, TimeUnit.MILLISECONDS)).submit(jobRequest, new JobResponseObserver(responseIterator, finished, counter));
        }
        return responseIterator;
    }

    public void shutdown() throws InterruptedException {
        for (RpcChannel rpcChannel : this.channels) {
            rpcChannel.shutdown();
        }
    }

    private static class JobResponseObserver
    implements StreamObserver<PegasusClient.JobResponse> {
        private final StreamIterator<PegasusClient.JobResponse> iterator;
        private final AtomicBoolean finished;
        private final AtomicInteger counter;

        public JobResponseObserver(StreamIterator<PegasusClient.JobResponse> iterator, AtomicBoolean finished, AtomicInteger counter) {
            this.iterator = iterator;
            this.finished = finished;
            this.counter = counter;
        }

        public void onNext(PegasusClient.JobResponse jobResponse) {
            if (this.finished.get()) {
                return;
            }
            try {
                this.iterator.putData(jobResponse);
            }
            catch (InterruptedException e) {
                this.onError(e);
            }
        }

        public void onError(Throwable throwable) {
            if (this.finished.getAndSet(true)) {
                return;
            }
            Status status = Status.fromThrowable((Throwable)throwable);
            logger.error("get job response error: {}", (Object)status);
            this.iterator.fail(throwable);
        }

        public void onCompleted() {
            logger.info("finish get job response from one server");
            if (this.counter.decrementAndGet() == 0) {
                logger.info("finish get job response from all servers");
                try {
                    this.iterator.finish();
                }
                catch (InterruptedException e) {
                    this.onError(e);
                }
            }
        }
    }
}

