/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus.builder;

import com.alibaba.pegasus.builder.AbstractBuilder;
import com.alibaba.pegasus.builder.Plan;
import com.alibaba.pegasus.builder.ReduceBuilder;
import com.alibaba.pegasus.intf.NestedFunc;
import com.alibaba.pegasus.service.job.protocol.JobClient;
import com.alibaba.pegasus.service.protocol.PegasusClient;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobBuilder
extends AbstractBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JobBuilder.class);

    public JobBuilder(PegasusClient.JobConfig conf, ByteString source, Plan plan, JobClient.Sink sink) {
        super(conf, source, plan, sink);
    }

    public JobBuilder(PegasusClient.JobConfig conf, ByteString source, Plan plan) {
        super(conf, source, plan);
    }

    public JobBuilder(PegasusClient.JobConfig conf, ByteString source) {
        super(conf, source);
    }

    public JobBuilder(PegasusClient.JobConfig conf) {
        super(conf);
    }

    public JobBuilder() {
    }

    public JobBuilder addSource(ByteString source) {
        this.source = source;
        return this;
    }

    public JobBuilder exchange(ByteString route) {
        this.plan.exchange(route);
        return this;
    }

    public JobBuilder broadcast() {
        this.plan.broadcast();
        return this;
    }

    public JobBuilder broadcastBy(ByteString route) {
        this.plan.broadcastBy(route);
        return this;
    }

    public JobBuilder aggregate(int target) {
        this.plan.aggregate(target);
        return this;
    }

    public JobBuilder map(ByteString func) {
        this.plan.map(func);
        return this;
    }

    public JobBuilder flatMap(ByteString func) {
        this.plan.flatMap(func);
        return this;
    }

    public JobBuilder filter(ByteString func) {
        this.plan.filter(func);
        return this;
    }

    public JobBuilder limit(int n) {
        this.plan.limit(n);
        return this;
    }

    public JobBuilder dedup() {
        this.plan.dedup();
        return this;
    }

    public JobBuilder repeat(int times, JobBuilder subPlan) {
        this.plan.repeat(times, subPlan.plan);
        return this;
    }

    public JobBuilder repeat(int times, NestedFunc func) {
        this.plan.repeat(times, func);
        return this;
    }

    public JobBuilder repeatUntil(int times, ByteString until, JobBuilder subPlan) {
        this.plan.repeateUntil(times, until, subPlan.plan);
        return this;
    }

    public JobBuilder repeatUntil(int times, ByteString until, NestedFunc func) {
        this.plan.repeateUntil(times, until, func);
        return this;
    }

    public JobBuilder fork(JobBuilder subPlan) {
        this.plan.fork(subPlan.getPlan());
        return this;
    }

    public JobBuilder fork(NestedFunc func) {
        this.plan.fork(func);
        return this;
    }

    public JobBuilder forkJoin(ByteString joiner, JobBuilder subPlan) {
        this.plan.forkJoin(joiner, subPlan.getPlan());
        return this;
    }

    public JobBuilder forkJoin(ByteString joiner, NestedFunc func) {
        this.plan.forkJoin(joiner, func);
        return this;
    }

    public JobBuilder union(List<JobBuilder> subPlans) {
        ArrayList<Plan> plans = new ArrayList<Plan>();
        subPlans.forEach(builder -> plans.add(builder.getPlan()));
        this.plan.union(plans);
        return this;
    }

    public JobBuilder sortBy(ByteString cmp) {
        this.plan.sortBy(cmp);
        return this;
    }

    public JobBuilder topBy(int n, ByteString cmp) {
        this.plan.topBy(n, cmp);
        return this;
    }

    public ReduceBuilder count() {
        this.plan.count();
        return new ReduceBuilder(this.conf, this.source, this.plan, this.sink);
    }

    public ReduceBuilder fold(JobClient.AccumKind accumKind) {
        this.plan.fold(accumKind);
        return new ReduceBuilder(this.conf, this.source, this.plan, this.sink);
    }

    public ReduceBuilder foldCustom(JobClient.AccumKind accumKind, ByteString accumFunc) {
        this.plan.foldCustom(accumKind, accumFunc);
        return new ReduceBuilder(this.conf, this.source, this.plan, this.sink);
    }

    public ReduceBuilder groupBy(JobClient.AccumKind accumKind, ByteString keySelector) {
        this.plan.groupBy(accumKind, keySelector);
        return new ReduceBuilder(this.conf, this.source, this.plan, this.sink);
    }

    public void sink(ByteString output) {
        this.sink = this.plan.sink(output);
    }

    public static void main(String[] args) {
        PegasusClient.JobConfig confPb = PegasusClient.JobConfig.newBuilder().setJobId(1L).setJobName("test").setWorkers(1).build();
        ByteString opBody = ByteString.EMPTY;
        JobBuilder jobBuilder = new JobBuilder(confPb, opBody);
        JobBuilder plan = new JobBuilder();
        PegasusClient.JobRequest jobReq = jobBuilder.map(opBody).flatMap(opBody).repeat(3, plan.flatMap(opBody).flatMap(opBody)).count().unfold(opBody).count().build();
        logger.info("send job req: {}", (Object)jobReq.toString());
    }
}

