/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus.builder;

import com.alibaba.pegasus.intf.NestedFunc;
import com.alibaba.pegasus.service.job.protocol.JobClient;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plan {
    private static final Logger logger = LoggerFactory.getLogger(Plan.class);
    private List<JobClient.OperatorDef> plan;

    public Plan(ArrayList<JobClient.OperatorDef> plan) {
        this.plan = plan;
    }

    public Plan() {
        this.plan = new ArrayList<JobClient.OperatorDef>();
    }

    public List<JobClient.OperatorDef> getPlan() {
        return this.plan;
    }

    public void setPlan(List<JobClient.OperatorDef> plan) {
        this.plan = plan;
    }

    public void exchange(ByteString route) {
        JobClient.Repartition exchange = JobClient.Repartition.newBuilder().setResource(route).build();
        JobClient.Communicate communicate = JobClient.Communicate.newBuilder().setToAnother(exchange).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setComm(communicate).build();
        this.plan.add(operatorDef);
    }

    public void broadcast() {
        JobClient.Broadcast broadcast = JobClient.Broadcast.newBuilder().build();
        JobClient.Communicate communicate = JobClient.Communicate.newBuilder().setToOthers(broadcast).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setComm(communicate).build();
        this.plan.add(operatorDef);
    }

    public void broadcastBy(ByteString route) {
        JobClient.Broadcast broadcast = JobClient.Broadcast.newBuilder().setResource(route).build();
        JobClient.Communicate communicate = JobClient.Communicate.newBuilder().setToOthers(broadcast).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setComm(communicate).build();
        this.plan.add(operatorDef);
    }

    public void aggregate(int target) {
        JobClient.Aggregate aggregate = JobClient.Aggregate.newBuilder().setTarget(target).build();
        JobClient.Communicate communicate = JobClient.Communicate.newBuilder().setToOne(aggregate).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setComm(communicate).build();
        this.plan.add(operatorDef);
    }

    public void map(ByteString func) {
        JobClient.Map map = JobClient.Map.newBuilder().setResource(func).build();
        JobClient.OperatorDef.Builder builder = JobClient.OperatorDef.newBuilder().setMap(map);
        JobClient.OperatorDef operatorDef = builder.build();
        this.plan.add(operatorDef);
    }

    public void flatMap(ByteString func) {
        JobClient.FlatMap flatMap = JobClient.FlatMap.newBuilder().setResource(func).build();
        JobClient.OperatorDef.Builder builder = JobClient.OperatorDef.newBuilder().setFlatMap(flatMap);
        JobClient.OperatorDef operatorDef = builder.build();
        this.plan.add(operatorDef);
    }

    public void filter(ByteString func) {
        JobClient.Filter filter = JobClient.Filter.newBuilder().setResource(func).build();
        JobClient.OperatorDef.Builder builder = JobClient.OperatorDef.newBuilder().setFilter(filter);
        JobClient.OperatorDef operatorDef = builder.build();
        this.plan.add(operatorDef);
    }

    public void limit(int n) {
        JobClient.Limit limitInfo = JobClient.Limit.newBuilder().setLimit(n).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setLimit(limitInfo).build();
        this.plan.add(operatorDef);
    }

    public void count() {
        JobClient.Fold fold = JobClient.Fold.newBuilder().setAccum(JobClient.AccumKind.CNT).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setFold(fold).build();
        this.plan.add(operatorDef);
    }

    public void fold(JobClient.AccumKind accumKind) {
        JobClient.Fold fold = JobClient.Fold.newBuilder().setAccum(accumKind).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setFold(fold).build();
        this.plan.add(operatorDef);
    }

    public void foldCustom(JobClient.AccumKind accumKind, ByteString accumFunc) {
        JobClient.Fold fold = JobClient.Fold.newBuilder().setAccum(accumKind).setResource(accumFunc).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setFold(fold).build();
        this.plan.add(operatorDef);
    }

    public void dedup() {
        JobClient.Dedup dedup = JobClient.Dedup.newBuilder().build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setDedup(dedup).build();
        this.plan.add(operatorDef);
    }

    public void repeat(int times, Plan subPlan) {
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(subPlan.getPlan()).build();
        JobClient.Iteration iteration = JobClient.Iteration.newBuilder().setMaxIters(times).setBody(taskPlan).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setIterate(iteration).build();
        this.plan.add(operatorDef);
    }

    public void repeat(int times, NestedFunc func) {
        Plan repeatedPlan = new Plan();
        func.nestedFunc(repeatedPlan);
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(repeatedPlan.getPlan()).build();
        JobClient.Iteration iteration = JobClient.Iteration.newBuilder().setMaxIters(times).setBody(taskPlan).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setIterate(iteration).build();
        this.plan.add(operatorDef);
    }

    public void repeateUntil(int times, ByteString until, Plan subPlan) {
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(subPlan.getPlan()).build();
        JobClient.Filter filterUntil = JobClient.Filter.newBuilder().setResource(until).build();
        JobClient.Iteration iteration = JobClient.Iteration.newBuilder().setMaxIters(times).setBody(taskPlan).setUntil(filterUntil).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setIterate(iteration).build();
        this.plan.add(operatorDef);
    }

    public void repeateUntil(int times, ByteString until, NestedFunc func) {
        Plan repeatedPlan = new Plan();
        func.nestedFunc(repeatedPlan);
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(repeatedPlan.getPlan()).build();
        JobClient.Filter filterUntil = JobClient.Filter.newBuilder().setResource(until).build();
        JobClient.Iteration iteration = JobClient.Iteration.newBuilder().setMaxIters(times).setBody(taskPlan).setUntil(filterUntil).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setIterate(iteration).build();
        this.plan.add(operatorDef);
    }

    public void fork(Plan subPlan) {
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(subPlan.getPlan()).build();
        JobClient.Apply subtask = JobClient.Apply.newBuilder().setTask(taskPlan).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setApply(subtask).build();
        this.plan.add(operatorDef);
    }

    public void fork(NestedFunc func) {
        Plan subPlan = new Plan();
        func.nestedFunc(subPlan);
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(subPlan.getPlan()).build();
        JobClient.Apply subtask = JobClient.Apply.newBuilder().setTask(taskPlan).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setApply(subtask).build();
        this.plan.add(operatorDef);
    }

    public void forkJoin(ByteString joiner, Plan subPlan) {
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(subPlan.getPlan()).build();
        JobClient.LeftJoin leftJoin = JobClient.LeftJoin.newBuilder().setResource(joiner).build();
        JobClient.Apply subtask = JobClient.Apply.newBuilder().setTask(taskPlan).setJoin(leftJoin).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setApply(subtask).build();
        this.plan.add(operatorDef);
    }

    public void forkJoin(ByteString joiner, NestedFunc func) {
        Plan subPlan = new Plan();
        func.nestedFunc(subPlan);
        JobClient.TaskPlan taskPlan = JobClient.TaskPlan.newBuilder().addAllPlan(subPlan.getPlan()).build();
        JobClient.LeftJoin leftJoin = JobClient.LeftJoin.newBuilder().setResource(joiner).build();
        JobClient.Apply subtask = JobClient.Apply.newBuilder().setTask(taskPlan).setJoin(leftJoin).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setApply(subtask).build();
        this.plan.add(operatorDef);
    }

    public void union(List<Plan> subPlans) {
        ArrayList unionTasks = new ArrayList();
        subPlans.forEach(plan -> unionTasks.add(JobClient.TaskPlan.newBuilder().addAllPlan(plan.getPlan()).build()));
        JobClient.Merge union = JobClient.Merge.newBuilder().addAllTasks(unionTasks).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setMerge(union).build();
        this.plan.add(operatorDef);
    }

    public void sortBy(ByteString cmp) {
        int noLimit = -1;
        JobClient.SortBy orderBy = JobClient.SortBy.newBuilder().setLimit(noLimit).setCompare(cmp).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setSort(orderBy).build();
        this.plan.add(operatorDef);
    }

    public void topBy(int n, ByteString cmp) {
        JobClient.SortBy orderBy = JobClient.SortBy.newBuilder().setLimit(n).setCompare(cmp).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setSort(orderBy).build();
        this.plan.add(operatorDef);
    }

    public void groupBy(JobClient.AccumKind accumKind, ByteString keySelector) {
        JobClient.GroupBy groupBy = JobClient.GroupBy.newBuilder().setAccum(accumKind).setResource(keySelector).build();
        JobClient.OperatorDef operatorDef = JobClient.OperatorDef.newBuilder().setGroup(groupBy).build();
        this.plan.add(operatorDef);
    }

    public JobClient.Sink sink(ByteString output) {
        return JobClient.Sink.newBuilder().setResource(output).build();
    }

    public void chainUnfold(ByteString func) {
        if (this.plan.size() > 0) {
            JobClient.OperatorDef pre = this.plan.remove(this.plan.size() - 1);
            JobClient.OperatorDef.Builder builder = pre.toBuilder();
            if (pre.getOpKindCase() == JobClient.OperatorDef.OpKindCase.GROUP) {
                builder.getGroupBuilder().getUnfoldBuilder().setResource(func);
            } else if (pre.getOpKindCase() == JobClient.OperatorDef.OpKindCase.FOLD) {
                builder.getFoldBuilder().getUnfoldBuilder().setResource(func);
            }
            JobClient.OperatorDef reduceChain = builder.build();
            this.plan.add(reduceChain);
        }
    }

    public boolean endReduce() {
        int len = this.plan.size();
        if (len == 0) {
            return false;
        }
        JobClient.OperatorDef.OpKindCase opKind = this.plan.get(len - 1).getOpKindCase();
        return opKind == JobClient.OperatorDef.OpKindCase.GROUP || opKind == JobClient.OperatorDef.OpKindCase.FOLD;
    }

    public JobClient.Sink genSink() {
        JobClient.Sink.Builder sinkBuilder = JobClient.Sink.newBuilder();
        return sinkBuilder.build();
    }

    private ByteString toBytes(boolean raw) {
        byte[] bytes = new byte[]{(byte)(raw ? 1 : 0)};
        return ByteString.copyFrom((byte[])bytes);
    }
}

