/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.pegasus.common;

import com.alibaba.pegasus.intf.CloseableIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamIterator<T>
implements CloseableIterator<T> {
    private static final Logger logger = LoggerFactory.getLogger(StreamIterator.class);
    private static final Object PILL = new Object();
    private BlockingQueue<Object> buffer;
    private Object head = null;
    private volatile boolean closed = false;
    private AtomicReference<Throwable> exception = new AtomicReference();

    public StreamIterator() {
        this.buffer = new LinkedBlockingQueue<Object>();
    }

    @Override
    public boolean hasNext() {
        Throwable t = this.exception.get();
        if (t != null) {
            throw new RuntimeException(t);
        }
        if (this.head == null) {
            try {
                this.head = this.buffer.take();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            if (this.head == PILL) {
                return false;
            }
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.head instanceof Throwable) {
            throw new RuntimeException((Throwable)this.head);
        }
        Object res = this.head;
        this.head = null;
        return (T)res;
    }

    public void putData(T data) throws InterruptedException {
        if (this.closed) {
            return;
        }
        this.buffer.put(data);
    }

    public void fail(Throwable t) {
        if (this.closed) {
            return;
        }
        boolean suc = this.exception.compareAndSet(null, t);
        if (!suc) {
            return;
        }
        logger.error("iterator failed", t);
        this.buffer.offer(t);
    }

    public void finish() throws InterruptedException {
        if (this.closed) {
            return;
        }
        this.buffer.put(PILL);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
        this.closed = true;
        this.buffer.clear();
    }
}

