/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;

@ChannelHandler.Sharable
public final class WebSocketGremlinRequestEncoder
extends MessageToMessageEncoder<RequestMessage> {
    private final boolean binaryEncoding;
    private final MessageSerializer<?> serializer;

    public WebSocketGremlinRequestEncoder(boolean binaryEncoding, MessageSerializer<?> serializer) {
        this.binaryEncoding = binaryEncoding;
        this.serializer = serializer;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, RequestMessage requestMessage, List<Object> objects) throws Exception {
        try {
            if (this.binaryEncoding) {
                ByteBuf encodedMessage = this.serializer.serializeRequestAsBinary(requestMessage, channelHandlerContext.alloc());
                objects.add(new BinaryWebSocketFrame(encodedMessage));
            } else {
                MessageTextSerializer textSerializer = (MessageTextSerializer)this.serializer;
                objects.add(new TextWebSocketFrame(textSerializer.serializeRequestAsString(requestMessage)));
            }
        }
        catch (Exception ex) {
            throw new ResponseException(ResponseStatusCode.REQUEST_ERROR_SERIALIZATION, String.format("An error occurred during serialization of this request [%s] - it could not be sent to the server - Reason: %s", requestMessage, ex));
        }
    }
}

