/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
export declare const handler: (event: any, context: any) => Promise<{
    Status: string;
    Reason: string;
    PhysicalResourceId: any;
    StackId: any;
    RequestId: any;
    LogicalResourceId: any;
    Data: {};
}>;
/**
 * Updates a provided key policy with a provided key policy statement. First checks whether the provided key policy statement
 * already exists. If an existing key policy is found with a matching sid, the provided key policy will overwrite the existing
 * key policy. If no matching key policy is found, the provided key policy will be appended onto the array of policy statements.
 * @param keyPolicy - the JSON.parse'd result of the otherwise stringified key policy.
 * @param keyPolicyStatement - the key policy statement to be added to the key policy.
 * @returns keyPolicy - the updated key policy.
 */
export declare const updateKeyPolicy: (keyPolicy: any, keyPolicyStatement: any) => any;
