/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cdk from "aws-cdk-lib";
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { CustomResource } from 'aws-cdk-lib';
import { IKey } from "aws-cdk-lib/aws-kms";
import { Distribution } from "aws-cdk-lib/aws-cloudfront";
import { Construct } from 'constructs';
export interface CreateKeyPolicyUpdaterResponse {
    readonly lambdaFunction: lambda.Function;
    readonly customResource: CustomResource;
}
export interface KeyPolicyUpdaterProps {
    readonly encryptionKey: IKey;
    readonly distribution: Distribution;
    readonly timeout?: cdk.Duration;
    readonly memorySize?: number;
}
export declare function createKeyPolicyUpdaterCustomResource(scope: Construct, props: KeyPolicyUpdaterProps): CreateKeyPolicyUpdaterResponse;
