"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCfnSuppressRulesForCustomResourceProvider = void 0;
const core_1 = require("@aws-solutions-constructs/core");
exports.addCfnSuppressRulesForCustomResourceProvider = (provider) => {
    const providerFrameworkFunction = provider.node.children[0].node.findChild('Resource');
    core_1.addCfnSuppressRules(providerFrameworkFunction, [
        {
            id: 'W58',
            reason: `The CDK-provided lambda function that backs their Custom Resource Provider framework has an IAM role with the arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole Managed Policy attached, which grants permission to write to CloudWatch Logs`
        },
        {
            id: 'W89',
            reason: `The CDK-provided lambda function that backs their Custom Resource Provider framework does not access VPC resources`
        },
        {
            id: 'W92',
            reason: `The CDK-provided lambda function that backs their Custom Resource Provider framework does not define ReservedConcurrentExecutions`
        }
    ]);
};
//# sourceMappingURL=data:application/json;base64,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