"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const core_1 = require("@aws-solutions-constructs/core");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const path = require("path");
const template_writer_1 = require("../lib/template-writer");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for Template Writer Resource';
const templateAsset = new aws_s3_assets_1.Asset(stack, 'TemplateAsset', {
    path: path.join(__dirname, 'template/sample-template')
});
const templateValues = new Array({
    id: 'placeholder',
    value: 'resolved_value'
});
template_writer_1.createTemplateWriterCustomResource(stack, 'Test', {
    templateBucket: templateAsset.bucket,
    templateKey: templateAsset.s3ObjectKey,
    templateValues
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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