"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const core_1 = require("@aws-solutions-constructs/core");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const path = require("path");
const template_writer_1 = require("../lib/template-writer");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for Template Writer Resource';
const templateAsset = new aws_s3_assets_1.Asset(stack, 'TemplateAsset', {
    path: path.join(__dirname, 'template/large-sample-template')
});
// this test will do a total of 5,760 substitutions across a 9.4MB text file
// Last integration test run used 286MB of memory with a function duration of 1.5 seconds
const templateValues = new Array({
    id: 'Lorem',
    value: 'LOREM_2'
}, {
    id: 'Velit',
    value: 'VELIT_2'
}, {
    id: 'Ornare',
    value: 'ORNARE_2'
}, {
    id: 'Ullamcorper',
    value: 'ULLAMCORPER_2'
}, {
    id: 'Blandit',
    value: 'BLANDIT_2'
}, {
    id: 'Bibendum',
    value: 'BIBENDUM_2'
});
template_writer_1.createTemplateWriterCustomResource(stack, 'Test', {
    templateBucket: templateAsset.bucket,
    templateKey: templateAsset.s3ObjectKey,
    templateValues,
    timeout: aws_cdk_lib_1.Duration.minutes(1),
    memorySize: 1024
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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