"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.constructInfoFromStack = exports.constructInfoFromConstruct = void 0;
const stack_1 = require("../stack");
const stage_1 = require("../stage");
const ALLOWED_FQN_PREFIXES = [
    // SCOPES
    '@aws-cdk/', '@aws-cdk-containers/', '@aws-solutions-konstruk/', '@aws-solutions-constructs/', '@amzn/',
    // PACKAGES
    'aws-rfdk.', 'aws-cdk-lib.', 'monocdk.',
];
/**
 * Symbol for accessing jsii runtime information
 *
 * Introduced in jsii 1.19.0, cdk 1.90.0.
 */
const JSII_RUNTIME_SYMBOL = Symbol.for('jsii.rtti');
function constructInfoFromConstruct(construct) {
    const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
    if (typeof jsiiRuntimeInfo === 'object'
        && jsiiRuntimeInfo !== null
        && typeof jsiiRuntimeInfo.fqn === 'string'
        && typeof jsiiRuntimeInfo.version === 'string') {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
    }
    else if (jsiiRuntimeInfo) {
        // There is something defined, but doesn't match our expectations. Fail fast and hard.
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    return undefined;
}
exports.constructInfoFromConstruct = constructInfoFromConstruct;
/**
 * For a given stack, walks the tree and finds the runtime info for all constructs within the tree.
 * Returns the unique list of construct info present in the stack,
 * as long as the construct fully-qualified names match the defined allow list.
 */
function constructInfoFromStack(stack) {
    const isDefined = (value) => value !== undefined;
    const allConstructInfos = constructsInStack(stack)
        .map(construct => constructInfoFromConstruct(construct))
        .filter(isDefined)
        .filter(info => ALLOWED_FQN_PREFIXES.find(prefix => info.fqn.startsWith(prefix)));
    // Adds the jsii runtime as a psuedo construct for reporting purposes.
    allConstructInfos.push({
        fqn: 'jsii-runtime.Runtime',
        version: getJsiiAgentVersion(),
    });
    // Filter out duplicate values
    const uniqKeys = new Set();
    return allConstructInfos.filter(construct => {
        const constructKey = `${construct.fqn}@${construct.version}`;
        const isDuplicate = uniqKeys.has(constructKey);
        uniqKeys.add(constructKey);
        return !isDuplicate;
    });
}
exports.constructInfoFromStack = constructInfoFromStack;
/**
 * Returns all constructs under the parent construct (including the parent),
 * stopping when it reaches a boundary of another stack (e.g., Stack, Stage, NestedStack).
 */
function constructsInStack(construct) {
    const constructs = [construct];
    construct.node.children
        .filter(child => !stage_1.Stage.isStage(child) && !stack_1.Stack.isStack(child))
        .forEach(child => constructs.push(...constructsInStack(child)));
    return constructs;
}
function getJsiiAgentVersion() {
    let jsiiAgent = process.env.JSII_AGENT;
    // if JSII_AGENT is not specified, we will assume this is a node.js runtime
    // and plug in our node.js version
    if (!jsiiAgent) {
        jsiiAgent = `node.js/${process.version}`;
    }
    return jsiiAgent;
}
//# sourceMappingURL=data:application/json;base64,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