/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.conformhelpers.decode;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.siemens.ct.exi.main.conformhelpers.decode.ChargeParameterDiscoveryRes;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChargeParameterDiscoveryResDecodeDeserializer
extends StdDeserializer<ChargeParameterDiscoveryRes> {
    public ChargeParameterDiscoveryResDecodeDeserializer() {
        this((Class<?>)null);
    }

    protected ChargeParameterDiscoveryResDecodeDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ChargeParameterDiscoveryRes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        ChargeParameterDiscoveryRes cpdr = new ChargeParameterDiscoveryRes();
        cpdr.getAdditionalProperties().put("ResponseCode", node.get("ResponseCode"));
        cpdr.getAdditionalProperties().put("EVSEProcessing", node.get("EVSEProcessing"));
        if (node.has("AC_EVSEChargeParameter")) {
            cpdr.getAdditionalProperties().put("AC_EVSEChargeParameter", node.get("AC_EVSEChargeParameter"));
        }
        if (node.has("SAScheduleList")) {
            cpdr.getAdditionalProperties().put("SAScheduleList", this.GetSAScheduleList(node));
        }
        return cpdr;
    }

    private JsonNode GetSAScheduleList(JsonNode node) throws JsonMappingException, JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        ObjectNode on = om.createObjectNode();
        ArrayNode services = on.putArray("SAScheduleTuple");
        JsonNode saScheduleList = node.get("SAScheduleList");
        JsonNode scheduleList = saScheduleList.get("SAScheduleTuple");
        for (JsonNode schedule : scheduleList) {
            JsonNode pmaxSchedule = this.GetPMAXSchedule(schedule);
            ObjectNode objectNode = (ObjectNode)schedule.deepCopy();
            objectNode.replace("PMaxSchedule", pmaxSchedule);
            ObjectNode jo = om.createObjectNode();
            jo.replace("SAScheduleTuple", om.readTree(objectNode.toString()));
            services.add(jo);
        }
        return om.readTree(services.toString());
    }

    private JsonNode GetPMAXSchedule(JsonNode node) throws JsonMappingException, JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        JSONArray arr = new JSONArray();
        JsonNode pmaxSchedule = node.get("PMaxSchedule");
        JSONArray allPMaxScheduleEntries = new JSONObject(pmaxSchedule.toString()).getJSONArray("PMaxScheduleEntry");
        for (Object se : allPMaxScheduleEntries) {
            JSONObject pMaxScheduleEntryNode = new JSONObject();
            pMaxScheduleEntryNode.put("PMaxScheduleEntry", se);
            arr.put(pMaxScheduleEntryNode);
        }
        return om.readTree(arr.toString());
    }
}

