import { aws_events as events, aws_lambda as lambda, aws_s3 as s3, aws_sns as sns, Duration, RemovalPolicy } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface CertbotProps {
    /**
     * The comma delimited list of domains for which the Let's Encrypt certificate will be valid. Primary domain should be first.
     */
    readonly letsencryptDomains: string;
    /**
     * The email to associate with the Let's Encrypt certificate request.
     */
    readonly letsencryptEmail: string;
    /**
     * Any additional Lambda layers to use with the created function. For example Lambda Extensions
     */
    readonly layers?: lambda.ILayerVersion[];
    /**
     * Hosted zone names that will be required for DNS verification with certbot
     */
    readonly hostedZoneNames: string[];
    /**
     * The S3 bucket to place the resulting certificates in. If no bucket is given one will be created automatically.
     */
    readonly bucket?: s3.Bucket;
    /**
     * The prefix to apply to the final S3 key name for the certificates. Default is no prefix.
     */
    readonly objectPrefix?: string;
    /**
     * The numbers of days left until the prior cert expires before issuing a new one.
     *
     * @default 30
     */
    readonly reIssueDays?: number;
    /**
     * Set the preferred certificate chain.
     *
     * @default 'None'
     */
    readonly preferredChain?: string;
    /**
     * The SNS topic to notify when a new cert is issued. If no topic is given one will be created automatically.
     */
    readonly snsTopic?: sns.Topic;
    /**
     * Whether or not to enable Lambda Insights
     *
     * @default false
     */
    readonly enableInsights?: boolean;
    /**
     * Insights layer ARN for your region. Defaults to layer for US-EAST-1
     */
    readonly insightsARN?: string;
    /**
     * The timeout duration for Lambda function
     *
     * @default Duraction.seconds(180)
     */
    readonly timeout?: Duration;
    /**
     * The schedule for the certificate check trigger.
     *
     * @default events.Schedule.cron({ minute: '0', hour: '0', weekDay: '1' })
     */
    readonly schedule?: events.Schedule;
    /**
     * Whether or not to schedule a trigger to run the function after each deployment
     *
     * @default true
     */
    readonly runOnDeploy?: boolean;
    /**
     * How many minutes to wait before running the post deployment Lambda trigger
     *
     * @default 10
     */
    readonly runOnDeployWaitMinutes?: number;
    /**
     * The description for the resulting Lambda function.
     */
    readonly functionDescription?: string;
    /**
     * The name of the resulting Lambda function.
     */
    readonly functionName?: string;
    /**
     * The removal policy for the S3 bucket that is automatically created.
     *
     * Has no effect if a bucket is given as a property
     *
     * @default RemovalPolicy.RETAIN
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * Whether or not to enable automatic object deletion if the provided bucket is deleted.
     *
     * Has no effect if a bucket is given as a property
     *
     * @default false
     */
    readonly enableObjectDeletion?: boolean;
}
export declare class Certbot extends Construct {
    readonly handler: lambda.Function;
    constructor(scope: Construct, id: string, props: CertbotProps);
}
