"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
    }
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        if (!api.domainName) {
            throw new Error(`API does not define a default domain name`);
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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