"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const ec2 = require("@aws-cdk/aws-ec2");
const route53 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const targets = require("../lib");
test('use InterfaceVpcEndpoint as record target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const vpc = new ec2.Vpc(stack, 'VPC');
    const interfaceVpcEndpoint = new ec2.InterfaceVpcEndpoint(stack, 'InterfaceEndpoint', {
        vpc,
        service: {
            name: 'com.amazonaws.us-west-2.workspaces',
            port: 80
        }
    });
    const zone = new route53.PrivateHostedZone(stack, 'PrivateZone', {
        vpc,
        zoneName: 'test.aws.cdk.com'
    });
    // WHEN
    new route53.ARecord(stack, "AliasEndpointRecord", {
        zone,
        recordName: 'foo',
        target: route53.RecordTarget.fromAlias(new targets.InterfaceVpcEndpointTarget(interfaceVpcEndpoint))
    });
    // THEN
    expect(stack).toHaveResource('AWS::Route53::RecordSet', {
        AliasTarget: {
            HostedZoneId: {
                "Fn::Select": [
                    0,
                    {
                        "Fn::Split": [
                            ":",
                            {
                                "Fn::Select": [
                                    0,
                                    {
                                        "Fn::GetAtt": [
                                            "InterfaceEndpoint12DE6E71",
                                            "DnsEntries"
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            DNSName: {
                "Fn::Select": [
                    1,
                    {
                        "Fn::Split": [
                            ":",
                            {
                                "Fn::Select": [
                                    0,
                                    {
                                        "Fn::GetAtt": [
                                            "InterfaceEndpoint12DE6E71",
                                            "DnsEntries"
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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