# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BdsInstanceResourcePrincipalConfigurationArgs', 'BdsInstanceResourcePrincipalConfiguration']

@pulumi.input_type
class BdsInstanceResourcePrincipalConfigurationArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[str],
                 cluster_admin_password: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 force_refresh_resource_principal_trigger: Optional[pulumi.Input[int]] = None,
                 session_token_life_span_duration_in_hours: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a BdsInstanceResourcePrincipalConfiguration resource.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded Cluster Admin Password for cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[int] force_refresh_resource_principal_trigger: (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        :param pulumi.Input[int] session_token_life_span_duration_in_hours: (Updatable) Life span in hours for the resource principal session token.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "display_name", display_name)
        if force_refresh_resource_principal_trigger is not None:
            pulumi.set(__self__, "force_refresh_resource_principal_trigger", force_refresh_resource_principal_trigger)
        if session_token_life_span_duration_in_hours is not None:
            pulumi.set(__self__, "session_token_life_span_duration_in_hours", session_token_life_span_duration_in_hours)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[str]:
        """
        Base-64 encoded Cluster Admin Password for cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="forceRefreshResourcePrincipalTrigger")
    def force_refresh_resource_principal_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        """
        return pulumi.get(self, "force_refresh_resource_principal_trigger")

    @force_refresh_resource_principal_trigger.setter
    def force_refresh_resource_principal_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "force_refresh_resource_principal_trigger", value)

    @property
    @pulumi.getter(name="sessionTokenLifeSpanDurationInHours")
    def session_token_life_span_duration_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Life span in hours for the resource principal session token.
        """
        return pulumi.get(self, "session_token_life_span_duration_in_hours")

    @session_token_life_span_duration_in_hours.setter
    def session_token_life_span_duration_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_token_life_span_duration_in_hours", value)


@pulumi.input_type
class _BdsInstanceResourcePrincipalConfigurationState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 force_refresh_resource_principal_trigger: Optional[pulumi.Input[int]] = None,
                 session_token_life_span_duration_in_hours: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_token_expiry: Optional[pulumi.Input[str]] = None,
                 time_token_refreshed: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceResourcePrincipalConfiguration resources.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded Cluster Admin Password for cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[int] force_refresh_resource_principal_trigger: (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        :param pulumi.Input[int] session_token_life_span_duration_in_hours: (Updatable) Life span in hours for the resource principal session token.
        :param pulumi.Input[str] state: The state of the ResourcePrincipalConfiguration.
        :param pulumi.Input[str] time_created: The time the ResourcePrincipalConfiguration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[str] time_token_expiry: the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.
        :param pulumi.Input[str] time_token_refreshed: the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the ResourcePrincipalConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if force_refresh_resource_principal_trigger is not None:
            pulumi.set(__self__, "force_refresh_resource_principal_trigger", force_refresh_resource_principal_trigger)
        if session_token_life_span_duration_in_hours is not None:
            pulumi.set(__self__, "session_token_life_span_duration_in_hours", session_token_life_span_duration_in_hours)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_token_expiry is not None:
            pulumi.set(__self__, "time_token_expiry", time_token_expiry)
        if time_token_refreshed is not None:
            pulumi.set(__self__, "time_token_refreshed", time_token_refreshed)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Base-64 encoded Cluster Admin Password for cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="forceRefreshResourcePrincipalTrigger")
    def force_refresh_resource_principal_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        """
        return pulumi.get(self, "force_refresh_resource_principal_trigger")

    @force_refresh_resource_principal_trigger.setter
    def force_refresh_resource_principal_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "force_refresh_resource_principal_trigger", value)

    @property
    @pulumi.getter(name="sessionTokenLifeSpanDurationInHours")
    def session_token_life_span_duration_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Life span in hours for the resource principal session token.
        """
        return pulumi.get(self, "session_token_life_span_duration_in_hours")

    @session_token_life_span_duration_in_hours.setter
    def session_token_life_span_duration_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_token_life_span_duration_in_hours", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the ResourcePrincipalConfiguration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the ResourcePrincipalConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeTokenExpiry")
    def time_token_expiry(self) -> Optional[pulumi.Input[str]]:
        """
        the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_token_expiry")

    @time_token_expiry.setter
    def time_token_expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_token_expiry", value)

    @property
    @pulumi.getter(name="timeTokenRefreshed")
    def time_token_refreshed(self) -> Optional[pulumi.Input[str]]:
        """
        the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_token_refreshed")

    @time_token_refreshed.setter
    def time_token_refreshed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_token_refreshed", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the ResourcePrincipalConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class BdsInstanceResourcePrincipalConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 force_refresh_resource_principal_trigger: Optional[pulumi.Input[int]] = None,
                 session_token_life_span_duration_in_hours: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance Resource Principal Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

        Create a resource principal session token configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_resource_principal_configuration = oci.big_data_service.BdsInstanceResourcePrincipalConfiguration("test_bds_instance_resource_principal_configuration",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_resource_principal_configuration_cluster_admin_password,
            display_name=bds_instance_resource_principal_configuration_display_name,
            session_token_life_span_duration_in_hours=bds_instance_resource_principal_configuration_session_token_life_span_duration_in_hours)
        ```

        ## Import

        BdsInstanceResourcePrincipalConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceResourcePrincipalConfiguration:BdsInstanceResourcePrincipalConfiguration test_bds_instance_resource_principal_configuration "bdsInstances/{bdsInstanceId}/resourcePrincipalConfigurations/{resourcePrincipalConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded Cluster Admin Password for cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[int] force_refresh_resource_principal_trigger: (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        :param pulumi.Input[int] session_token_life_span_duration_in_hours: (Updatable) Life span in hours for the resource principal session token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceResourcePrincipalConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance Resource Principal Configuration resource in Oracle Cloud Infrastructure Big Data Service service.

        Create a resource principal session token configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_resource_principal_configuration = oci.big_data_service.BdsInstanceResourcePrincipalConfiguration("test_bds_instance_resource_principal_configuration",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_resource_principal_configuration_cluster_admin_password,
            display_name=bds_instance_resource_principal_configuration_display_name,
            session_token_life_span_duration_in_hours=bds_instance_resource_principal_configuration_session_token_life_span_duration_in_hours)
        ```

        ## Import

        BdsInstanceResourcePrincipalConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:BigDataService/bdsInstanceResourcePrincipalConfiguration:BdsInstanceResourcePrincipalConfiguration test_bds_instance_resource_principal_configuration "bdsInstances/{bdsInstanceId}/resourcePrincipalConfigurations/{resourcePrincipalConfigurationId}"
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceResourcePrincipalConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceResourcePrincipalConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 force_refresh_resource_principal_trigger: Optional[pulumi.Input[int]] = None,
                 session_token_life_span_duration_in_hours: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceResourcePrincipalConfigurationArgs.__new__(BdsInstanceResourcePrincipalConfigurationArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["force_refresh_resource_principal_trigger"] = force_refresh_resource_principal_trigger
            __props__.__dict__["session_token_life_span_duration_in_hours"] = session_token_life_span_duration_in_hours
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_token_expiry"] = None
            __props__.__dict__["time_token_refreshed"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceResourcePrincipalConfiguration, __self__).__init__(
            'oci:BigDataService/bdsInstanceResourcePrincipalConfiguration:BdsInstanceResourcePrincipalConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[str]] = None,
            cluster_admin_password: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            force_refresh_resource_principal_trigger: Optional[pulumi.Input[int]] = None,
            session_token_life_span_duration_in_hours: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_token_expiry: Optional[pulumi.Input[str]] = None,
            time_token_refreshed: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'BdsInstanceResourcePrincipalConfiguration':
        """
        Get an existing BdsInstanceResourcePrincipalConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[str] cluster_admin_password: Base-64 encoded Cluster Admin Password for cluster admin user.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        :param pulumi.Input[int] force_refresh_resource_principal_trigger: (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        :param pulumi.Input[int] session_token_life_span_duration_in_hours: (Updatable) Life span in hours for the resource principal session token.
        :param pulumi.Input[str] state: The state of the ResourcePrincipalConfiguration.
        :param pulumi.Input[str] time_created: The time the ResourcePrincipalConfiguration was created, shown as an RFC 3339 formatted datetime string.
        :param pulumi.Input[str] time_token_expiry: the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.
        :param pulumi.Input[str] time_token_refreshed: the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the ResourcePrincipalConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceResourcePrincipalConfigurationState.__new__(_BdsInstanceResourcePrincipalConfigurationState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["force_refresh_resource_principal_trigger"] = force_refresh_resource_principal_trigger
        __props__.__dict__["session_token_life_span_duration_in_hours"] = session_token_life_span_duration_in_hours
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_token_expiry"] = time_token_expiry
        __props__.__dict__["time_token_refreshed"] = time_token_refreshed
        __props__.__dict__["time_updated"] = time_updated
        return BdsInstanceResourcePrincipalConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[str]:
        """
        Base-64 encoded Cluster Admin Password for cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="forceRefreshResourcePrincipalTrigger")
    def force_refresh_resource_principal_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Force Refresh Resource Principal. Could be set to any integer value.
        """
        return pulumi.get(self, "force_refresh_resource_principal_trigger")

    @property
    @pulumi.getter(name="sessionTokenLifeSpanDurationInHours")
    def session_token_life_span_duration_in_hours(self) -> pulumi.Output[int]:
        """
        (Updatable) Life span in hours for the resource principal session token.
        """
        return pulumi.get(self, "session_token_life_span_duration_in_hours")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the ResourcePrincipalConfiguration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the ResourcePrincipalConfiguration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTokenExpiry")
    def time_token_expiry(self) -> pulumi.Output[str]:
        """
        the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_token_expiry")

    @property
    @pulumi.getter(name="timeTokenRefreshed")
    def time_token_refreshed(self) -> pulumi.Output[str]:
        """
        the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_token_refreshed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the ResourcePrincipalConfiguration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

