# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    """
    A collection of values returned by getApplication.
    """
    def __init__(__self__, application_id=None, application_log_configs=None, archive_uri=None, arguments=None, class_name=None, compartment_id=None, configuration=None, defined_tags=None, description=None, display_name=None, driver_shape=None, driver_shape_configs=None, execute=None, executor_shape=None, executor_shape_configs=None, file_uri=None, freeform_tags=None, id=None, idle_timeout_in_minutes=None, language=None, logs_bucket_uri=None, max_duration_in_minutes=None, metastore_id=None, num_executors=None, owner_principal_id=None, owner_user_name=None, parameters=None, pool_id=None, private_endpoint_id=None, spark_version=None, state=None, time_created=None, time_updated=None, type=None, warehouse_bucket_uri=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if application_log_configs and not isinstance(application_log_configs, list):
            raise TypeError("Expected argument 'application_log_configs' to be a list")
        pulumi.set(__self__, "application_log_configs", application_log_configs)
        if archive_uri and not isinstance(archive_uri, str):
            raise TypeError("Expected argument 'archive_uri' to be a str")
        pulumi.set(__self__, "archive_uri", archive_uri)
        if arguments and not isinstance(arguments, list):
            raise TypeError("Expected argument 'arguments' to be a list")
        pulumi.set(__self__, "arguments", arguments)
        if class_name and not isinstance(class_name, str):
            raise TypeError("Expected argument 'class_name' to be a str")
        pulumi.set(__self__, "class_name", class_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration and not isinstance(configuration, dict):
            raise TypeError("Expected argument 'configuration' to be a dict")
        pulumi.set(__self__, "configuration", configuration)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if driver_shape and not isinstance(driver_shape, str):
            raise TypeError("Expected argument 'driver_shape' to be a str")
        pulumi.set(__self__, "driver_shape", driver_shape)
        if driver_shape_configs and not isinstance(driver_shape_configs, list):
            raise TypeError("Expected argument 'driver_shape_configs' to be a list")
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        if execute and not isinstance(execute, str):
            raise TypeError("Expected argument 'execute' to be a str")
        pulumi.set(__self__, "execute", execute)
        if executor_shape and not isinstance(executor_shape, str):
            raise TypeError("Expected argument 'executor_shape' to be a str")
        pulumi.set(__self__, "executor_shape", executor_shape)
        if executor_shape_configs and not isinstance(executor_shape_configs, list):
            raise TypeError("Expected argument 'executor_shape_configs' to be a list")
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        if file_uri and not isinstance(file_uri, str):
            raise TypeError("Expected argument 'file_uri' to be a str")
        pulumi.set(__self__, "file_uri", file_uri)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes and not isinstance(idle_timeout_in_minutes, str):
            raise TypeError("Expected argument 'idle_timeout_in_minutes' to be a str")
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if language and not isinstance(language, str):
            raise TypeError("Expected argument 'language' to be a str")
        pulumi.set(__self__, "language", language)
        if logs_bucket_uri and not isinstance(logs_bucket_uri, str):
            raise TypeError("Expected argument 'logs_bucket_uri' to be a str")
        pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        if max_duration_in_minutes and not isinstance(max_duration_in_minutes, str):
            raise TypeError("Expected argument 'max_duration_in_minutes' to be a str")
        pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        if metastore_id and not isinstance(metastore_id, str):
            raise TypeError("Expected argument 'metastore_id' to be a str")
        pulumi.set(__self__, "metastore_id", metastore_id)
        if num_executors and not isinstance(num_executors, int):
            raise TypeError("Expected argument 'num_executors' to be a int")
        pulumi.set(__self__, "num_executors", num_executors)
        if owner_principal_id and not isinstance(owner_principal_id, str):
            raise TypeError("Expected argument 'owner_principal_id' to be a str")
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        if owner_user_name and not isinstance(owner_user_name, str):
            raise TypeError("Expected argument 'owner_user_name' to be a str")
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)
        if private_endpoint_id and not isinstance(private_endpoint_id, str):
            raise TypeError("Expected argument 'private_endpoint_id' to be a str")
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if spark_version and not isinstance(spark_version, str):
            raise TypeError("Expected argument 'spark_version' to be a str")
        pulumi.set(__self__, "spark_version", spark_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if warehouse_bucket_uri and not isinstance(warehouse_bucket_uri, str):
            raise TypeError("Expected argument 'warehouse_bucket_uri' to be a str")
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetApplicationApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> Mapping[str, str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. This name is not necessarily unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetApplicationDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter
    def execute(self) -> str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetApplicationExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The application ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetApplicationParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of this application.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_id=self.application_id,
            application_log_configs=self.application_log_configs,
            archive_uri=self.archive_uri,
            arguments=self.arguments,
            class_name=self.class_name,
            compartment_id=self.compartment_id,
            configuration=self.configuration,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            driver_shape=self.driver_shape,
            driver_shape_configs=self.driver_shape_configs,
            execute=self.execute,
            executor_shape=self.executor_shape,
            executor_shape_configs=self.executor_shape_configs,
            file_uri=self.file_uri,
            freeform_tags=self.freeform_tags,
            id=self.id,
            idle_timeout_in_minutes=self.idle_timeout_in_minutes,
            language=self.language,
            logs_bucket_uri=self.logs_bucket_uri,
            max_duration_in_minutes=self.max_duration_in_minutes,
            metastore_id=self.metastore_id,
            num_executors=self.num_executors,
            owner_principal_id=self.owner_principal_id,
            owner_user_name=self.owner_user_name,
            parameters=self.parameters,
            pool_id=self.pool_id,
            private_endpoint_id=self.private_endpoint_id,
            spark_version=self.spark_version,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            warehouse_bucket_uri=self.warehouse_bucket_uri)


def get_application(application_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    This data source provides details about a specific Application resource in Oracle Cloud Infrastructure Data Flow service.

    Retrieves an application using an `applicationId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_application = oci.DataFlow.get_application(application_id=test_application_oci_dataflow_application["id"])
    ```


    :param str application_id: The unique ID for an application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        application_log_configs=pulumi.get(__ret__, 'application_log_configs'),
        archive_uri=pulumi.get(__ret__, 'archive_uri'),
        arguments=pulumi.get(__ret__, 'arguments'),
        class_name=pulumi.get(__ret__, 'class_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration=pulumi.get(__ret__, 'configuration'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        driver_shape=pulumi.get(__ret__, 'driver_shape'),
        driver_shape_configs=pulumi.get(__ret__, 'driver_shape_configs'),
        execute=pulumi.get(__ret__, 'execute'),
        executor_shape=pulumi.get(__ret__, 'executor_shape'),
        executor_shape_configs=pulumi.get(__ret__, 'executor_shape_configs'),
        file_uri=pulumi.get(__ret__, 'file_uri'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__ret__, 'idle_timeout_in_minutes'),
        language=pulumi.get(__ret__, 'language'),
        logs_bucket_uri=pulumi.get(__ret__, 'logs_bucket_uri'),
        max_duration_in_minutes=pulumi.get(__ret__, 'max_duration_in_minutes'),
        metastore_id=pulumi.get(__ret__, 'metastore_id'),
        num_executors=pulumi.get(__ret__, 'num_executors'),
        owner_principal_id=pulumi.get(__ret__, 'owner_principal_id'),
        owner_user_name=pulumi.get(__ret__, 'owner_user_name'),
        parameters=pulumi.get(__ret__, 'parameters'),
        pool_id=pulumi.get(__ret__, 'pool_id'),
        private_endpoint_id=pulumi.get(__ret__, 'private_endpoint_id'),
        spark_version=pulumi.get(__ret__, 'spark_version'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        warehouse_bucket_uri=pulumi.get(__ret__, 'warehouse_bucket_uri'))


@_utilities.lift_output_func(get_application)
def get_application_output(application_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    This data source provides details about a specific Application resource in Oracle Cloud Infrastructure Data Flow service.

    Retrieves an application using an `applicationId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_application = oci.DataFlow.get_application(application_id=test_application_oci_dataflow_application["id"])
    ```


    :param str application_id: The unique ID for an application.
    """
    ...
