# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 keys: pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]],
                 table_name_or_id: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_if_not_exists: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]] keys: A set of keys for a secondary index.
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[bool] is_if_not_exists: If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        :param pulumi.Input[str] name: Index name.
        """
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "table_name_or_id", table_name_or_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_if_not_exists is not None:
            pulumi.set(__self__, "is_if_not_exists", is_if_not_exists)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]]:
        """
        A set of keys for a secondary index.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> pulumi.Input[str]:
        """
        A table name within the compartment, or a table OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "table_name_or_id")

    @table_name_or_id.setter
    def table_name_or_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name_or_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isIfNotExists")
    def is_if_not_exists(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        """
        return pulumi.get(self, "is_if_not_exists")

    @is_if_not_exists.setter
    def is_if_not_exists(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_if_not_exists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Index name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_if_not_exists: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 table_name_or_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[bool] is_if_not_exists: If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        :param pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]] keys: A set of keys for a secondary index.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail.
        :param pulumi.Input[str] name: Index name.
        :param pulumi.Input[str] state: The state of an index.
        :param pulumi.Input[str] table_id: the OCID of the table to which this index belongs.
        :param pulumi.Input[str] table_name: The name of the table to which this index belongs.
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_if_not_exists is not None:
            pulumi.set(__self__, "is_if_not_exists", is_if_not_exists)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if table_name_or_id is not None:
            pulumi.set(__self__, "table_name_or_id", table_name_or_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isIfNotExists")
    def is_if_not_exists(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        """
        return pulumi.get(self, "is_if_not_exists")

    @is_if_not_exists.setter
    def is_if_not_exists(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_if_not_exists", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]]]:
        """
        A set of keys for a secondary index.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Index name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of an index.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[str]]:
        """
        the OCID of the table to which this index belongs.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table to which this index belongs.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> Optional[pulumi.Input[str]]:
        """
        A table name within the compartment, or a table OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "table_name_or_id")

    @table_name_or_id.setter
    def table_name_or_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name_or_id", value)


class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_if_not_exists: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexKeyArgs', 'IndexKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 table_name_or_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Index resource in Oracle Cloud Infrastructure NoSQL Database service.

        Create a new index on the table identified by tableNameOrId.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_index = oci.nosql.Index("test_index",
            keys=[{
                "column_name": index_keys_column_name,
                "json_field_type": index_keys_json_field_type,
                "json_path": index_keys_json_path,
            }],
            name=index_name,
            table_name_or_id=test_table_name_or["id"],
            compartment_id=compartment_id,
            is_if_not_exists=index_is_if_not_exists)
        ```

        ## Import

        Indexes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Nosql/index:Index test_index "tables/{tableNameOrId}/indexes/{indexName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[bool] is_if_not_exists: If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexKeyArgs', 'IndexKeyArgsDict']]]] keys: A set of keys for a secondary index.
        :param pulumi.Input[str] name: Index name.
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Index resource in Oracle Cloud Infrastructure NoSQL Database service.

        Create a new index on the table identified by tableNameOrId.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_index = oci.nosql.Index("test_index",
            keys=[{
                "column_name": index_keys_column_name,
                "json_field_type": index_keys_json_field_type,
                "json_path": index_keys_json_path,
            }],
            name=index_name,
            table_name_or_id=test_table_name_or["id"],
            compartment_id=compartment_id,
            is_if_not_exists=index_is_if_not_exists)
        ```

        ## Import

        Indexes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Nosql/index:Index test_index "tables/{tableNameOrId}/indexes/{indexName}"
        ```

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_if_not_exists: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexKeyArgs', 'IndexKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 table_name_or_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["is_if_not_exists"] = is_if_not_exists
            if keys is None and not opts.urn:
                raise TypeError("Missing required property 'keys'")
            __props__.__dict__["keys"] = keys
            __props__.__dict__["name"] = name
            if table_name_or_id is None and not opts.urn:
                raise TypeError("Missing required property 'table_name_or_id'")
            __props__.__dict__["table_name_or_id"] = table_name_or_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["table_id"] = None
            __props__.__dict__["table_name"] = None
        super(Index, __self__).__init__(
            'oci:Nosql/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            is_if_not_exists: Optional[pulumi.Input[bool]] = None,
            keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexKeyArgs', 'IndexKeyArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            table_id: Optional[pulumi.Input[str]] = None,
            table_name: Optional[pulumi.Input[str]] = None,
            table_name_or_id: Optional[pulumi.Input[str]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[bool] is_if_not_exists: If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexKeyArgs', 'IndexKeyArgsDict']]]] keys: A set of keys for a secondary index.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail.
        :param pulumi.Input[str] name: Index name.
        :param pulumi.Input[str] state: The state of an index.
        :param pulumi.Input[str] table_id: the OCID of the table to which this index belongs.
        :param pulumi.Input[str] table_name: The name of the table to which this index belongs.
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_if_not_exists"] = is_if_not_exists
        __props__.__dict__["keys"] = keys
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["state"] = state
        __props__.__dict__["table_id"] = table_id
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["table_name_or_id"] = table_name_or_id
        return Index(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="isIfNotExists")
    def is_if_not_exists(self) -> pulumi.Output[bool]:
        """
        If true, the operation completes successfully even when the index exists.  Otherwise, an attempt to create an index that already exists will return an error.
        """
        return pulumi.get(self, "is_if_not_exists")

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Sequence['outputs.IndexKey']]:
        """
        A set of keys for a secondary index.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Index name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of an index.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Output[str]:
        """
        the OCID of the table to which this index belongs.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[str]:
        """
        The name of the table to which this index belongs.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> pulumi.Output[str]:
        """
        A table name within the compartment, or a table OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "table_name_or_id")

