# Copyright 2023 Jij Inc.

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

include(FetchContent)

message(CHECK_START "cimod")
list(APPEND CMAKE_MESSAGE_INDENT "  ")

set(FETCHCONTENT_QUIET OFF)


#### Cimod ####
FetchContent_Declare(
    cimod
    GIT_REPOSITORY  https://github.com/C2iteam/vqa-cimod
    GIT_TAG         main
    GIT_SHALLOW     TRUE
    )

FetchContent_MakeAvailable(cimod)


list(POP_BACK CMAKE_MESSAGE_INDENT)
message(CHECK_PASS "fetched")
