from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

@dataclass
class ConsultarMovimientosAfiliatoriosPostRequestBody(AdditionalDataHolder, Parsable):
    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: Dict[str, Any] = field(default_factory=dict)

    # Specify a batch to retrieve movements. If you don't specify one, you will retrieve all batches.
    lote: Optional[str] = None
    # Please provide a valid URL format. Here, we provide you with the IDSE movements.
    webhook: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> ConsultarMovimientosAfiliatoriosPostRequestBody:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: ConsultarMovimientosAfiliatoriosPostRequestBody
        """
        if not parse_node:
            raise TypeError("parse_node cannot be null.")
        return ConsultarMovimientosAfiliatoriosPostRequestBody()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields: Dict[str, Callable[[Any], None]] = {
            "lote": lambda n : setattr(self, 'lote', n.get_str_value()),
            "webhook": lambda n : setattr(self, 'webhook', n.get_str_value()),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if not writer:
            raise TypeError("writer cannot be null.")
        writer.write_str_value("lote", self.lote)
        writer.write_str_value("webhook", self.webhook)
        writer.write_additional_data_value(self.additional_data)
    

