# -*- coding: utf-8 -*-
#
# Copyright (C) 2021 Northwestern University.
#
# Invenio-Vocabularies is free software; you can redistribute it and/or
# modify it under the terms of the MIT License; see LICENSE file for more
# details.

"""create_vocabularies_subtype."""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '1d3302223885'
down_revision = '6312f33645c1'
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'vocabularies_subtypes',
        sa.Column('id', sa.String(), nullable=False),
        sa.Column('vocabulary_id', sa.String(), nullable=False),
        sa.Column('label', sa.String(), nullable=True),
        sa.Column('prefix_url', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ['vocabulary_id'],
            ['vocabularies_types.id'],
            name=op.f(
                'fk_vocabularies_subtypes_vocabulary_id_vocabularies_types'
            ),
            ondelete='CASCADE'
        ),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_vocabularies_subtypes'))
    )
    # ### end Alembic commands ###


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('vocabularies_subtypes')
    # ### end Alembic commands ###
