# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_pingme_api.ipynb.

# %% auto 0
__all__ = ['app', 'webhook_card_default', 'webhook_card_simple', 'webhook_card', 'help', 'webservice']

# %% ../nbs/03_pingme_api.ipynb 4
import uvicorn  # Server for hosting the API, ref: https://www.uvicorn.org/
from fastapi import FastAPI  # library for creating the API
from fastapi.testclient import TestClient  # test client for notebook to test API calls
from fastapi import HTTPException  # for raising exceptions

from .core import settings
from . import core
from .pingme_class import Card
from .services import NotificationService

from fastcore.script import (
    call_parse,  # To create a CLI from a function
)

import json  # for parsing json data

# %% ../nbs/03_pingme_api.ipynb 6
app = FastAPI()

# %% ../nbs/03_pingme_api.ipynb 7
@app.post("/webhook/default")
def webhook_card_default():
    """
    Send a default card to the webhook, intention is strictly for testing and showcasing.
    """
    try:
        return NotificationService.send_default_card_to_webhook()
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

# %% ../nbs/03_pingme_api.ipynb 9
@app.post("/webhook/simple")
def webhook_card_simple(title: str, text: str):
    """
    Send a simple card to the webhook, should be used for most general use cases of sending a message.

    Args:
    title: Title of the card
    text: Text of the card
    """
    try:
        return NotificationService.send_simple_card_to_webhook(title, text)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

# %% ../nbs/03_pingme_api.ipynb 11
@app.post("/webhook/card/")
def webhook_card(card: Card):
    """
    Send a card to the webhook, card defines a card thats installed into the config.yaml. Advanced usage which may not get used.

    Args:
    card: Card object
    """
    try:
        return NotificationService.send_card_to_webhook(card)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

# %% ../nbs/03_pingme_api.ipynb 13
@app.get(path="/")
@app.get("/help", tags=["help"])
async def help():
    """
    Information on how to use API to users, when they hit the root URL. Ensure when you add new endpoints to update this function, check /docs for info on endpoints.
    """
    return {"msg": "please check /docs for more information on how to use the API"}

# %% ../nbs/03_pingme_api.ipynb 15
@call_parse
def webservice(
    host: str = "127.0.0.1",  # Host to run the server on
    port: int = 5000,  # Port to run the server on"
    config_file: str = None,  # Path to config file"
):
    """Start the PingMe API server."""
    # Override settings if provided
    if config_file is not None:
        settings.config_file = config_file

    # Run using module path instead of app instance to ensure updated config
    uvicorn.run("pingme.api:app", host=host, port=port, reload=core.DEV_MODE)
